"use strict";
(self["webpackChunkafterlogic_aurora_platform"] = self["webpackChunkafterlogic_aurora_platform"] || []).push([[11],{

/***/ "Z1Ji":
/*!****************************************************************!*\
  !*** ./modules/FilesCutCopyPasteWebclientPlugin/js/manager.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



module.exports = function (oAppData) {
  var App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o");
  if (App.isUserNormalOrTenant()) {
    return {
      start: function start(ModulesManager) {
        ModulesManager.run('FilesWebclient', 'registerToolbarButtons', [__webpack_require__(/*! modules/FilesCutCopyPasteWebclientPlugin/js/views/ButtonsView.js */ "t1SQ")]);
      }
    };
  }
  return null;
};

/***/ }),

/***/ "t1SQ":
/*!**************************************************************************!*\
  !*** ./modules/FilesCutCopyPasteWebclientPlugin/js/views/ButtonsView.js ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Utils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Common.js */ "uQaC"),
  Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "PMEU"),
  AlertPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/AlertPopup.js */ "Rjyw");
CButtonsView;

/**
 * @constructor 
 */
function CButtonsView() {
  this.oFilesView = null;
  this.copiedItems = ko.observableArray([]);
  this.cuttedItems = ko.observableArray([]);
  this.sharedParentFolderWhereItemsCutFrom = ko.observable(null);
  this.savedItemsCount = ko.computed(function () {
    return this.cuttedItems().length + this.copiedItems().length;
  }, this);
  this.pasteTooltip = ko.computed(function () {
    var aItems = _.union(this.cuttedItems(), this.copiedItems());
    if (aItems.length > 0) {
      return TextUtils.i18n('FILESCUTCOPYPASTEWEBCLIENTPLUGIN/ACTION_PASTE') + ': <br/>' + _.map(aItems, function (oFile) {
        return oFile.fileName();
      }).join(',<br/>');
    } else {
      return TextUtils.i18n('FILESCUTCOPYPASTEWEBCLIENTPLUGIN/ACTION_PASTE');
    }
  }, this);
}
CButtonsView.prototype.ViewTemplate = 'FilesCutCopyPasteWebclientPlugin_ButtonsView';
CButtonsView.prototype.useFilesViewData = function (filesView) {
  this.oFilesView = filesView;
  this.cutCommand = Utils.createCommand(this, this.executeCut, filesView.isCutAllowed);
  this.copyCommand = Utils.createCommand(this, this.executeCopy, filesView.isCopyAllowed);
  this.isPasteAllowed = ko.computed(function () {
    var allowPaste = false,
      sharedParentFolder = filesView.sharedParentFolder();
    if (this.copiedItems().length > 0) {
      allowPaste = !filesView.isSharedStorage() && !sharedParentFolder || sharedParentFolder && sharedParentFolder.sharedWithMeAccessWrite();
    }
    if (this.cuttedItems().length > 0) {
      allowPaste = filesView.storageType() === Enums.FileStorageType.Personal && (!sharedParentFolder || sharedParentFolder && sharedParentFolder.sharedWithMeAccessWrite()) || filesView.isCorporateStorage() || filesView.isSharedStorage() && sharedParentFolder && sharedParentFolder.sharedWithMeAccessWrite();
    }
    return allowPaste;
  }, this);
  this.pasteCommand = Utils.createCommand(this, this.executePaste, this.isPasteAllowed);
};
CButtonsView.prototype.executeCut = function () {
  this.copiedItems([]);
  this.cuttedItems(this.oFilesView.selector.listCheckedAndSelected());
  this.sharedParentFolderWhereItemsCutFrom(this.oFilesView.sharedParentFolder());
  Popups.showPopup(AlertPopup, [TextUtils.i18n('FILESCUTCOPYPASTEWEBCLIENTPLUGIN/INFO_ITEMS_CUTTED')]);
};
CButtonsView.prototype.executeCopy = function () {
  this.copiedItems(this.oFilesView.selector.listCheckedAndSelected());
  this.cuttedItems([]);
  Popups.showPopup(AlertPopup, [TextUtils.i18n('FILESCUTCOPYPASTEWEBCLIENTPLUGIN/INFO_ITEMS_COPIED')]);
};
CButtonsView.prototype.executePaste = function () {
  if (this.cuttedItems().length > 0) {
    this.oFilesView.moveItems('Move', this.oFilesView.getCurrentFolder(), this.cuttedItems());
    this.cuttedItems([]);
  }
  if (this.copiedItems().length > 0) {
    this.oFilesView.moveItems('Copy', this.oFilesView.getCurrentFolder(), this.copiedItems());
    this.copiedItems([]);
  }
};
module.exports = new CButtonsView();

/***/ })

}]);