(self["webpackChunkafterlogic_aurora_platform"] = self["webpackChunkafterlogic_aurora_platform"] || []).push([[39],{

/***/ "DSoz":
/*!***********************************************!*\
  !*** ./modules/CoreWebclient/js/CSelector.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _ = __webpack_require__(/*! underscore */ "C3HO"),
  $ = __webpack_require__(/*! jquery */ "M4cL"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9"),
  Utils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Common.js */ "uQaC"),
  App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
  Browser = __webpack_require__(/*! modules/CoreWebclient/js/Browser.js */ "/Odb"),
  Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "PMEU");

/**
 * @param {Function} list (knockout)
 * @param {Function=} fSelectCallback
 * @param {Function=} fDeleteCallback
 * @param {Function=} fDblClickCallback
 * @param {Function=} fEnterCallback
 * @param {Function=} multiplyLineFactor (knockout)
 * @param {boolean=} bResetCheckedOnClick = false
 * @param {boolean=} bCheckOnSelect = false
 * @param {boolean=} bUnselectOnCtrl = false
 * @param {boolean=} bDisableMultiplySelection = false
 * @param {boolean=} bChangeOnSelect = true
 * @constructor
 */
function CSelector(list, fSelectCallback, fDeleteCallback, fDblClickCallback, fEnterCallback, multiplyLineFactor, bResetCheckedOnClick, bCheckOnSelect, bUnselectOnCtrl, bDisableMultiplySelection, bChangeOnSelect) {
  this.active = ko.observable(false);
  this.fSelectCallback = fSelectCallback || function () {};
  this.fDeleteCallback = fDeleteCallback || function () {};
  this.fDblClickCallback = !App.isMobile() && fDblClickCallback ? fDblClickCallback : function () {};
  this.fEnterCallback = fEnterCallback || function () {};
  this.bResetCheckedOnClick = !!bResetCheckedOnClick;
  this.bCheckOnSelect = !!bCheckOnSelect;
  this.bUnselectOnCtrl = !!bUnselectOnCtrl;
  this.bDisableMultiplySelection = !!bDisableMultiplySelection;
  this.bChangeOnSelect = typeof bChangeOnSelect === 'undefined' ? true : !!bChangeOnSelect;
  this.useKeyboardKeys = ko.observable(false);
  this.list = ko.observableArray([]);
  if (list && list['subscribe']) {
    list['subscribe'](function (mValue) {
      this.list(mValue);
    }, this);
  }
  this.multiplyLineFactor = multiplyLineFactor;
  this.oLast = null;
  this.oListScope = null;
  this.oScrollScope = null;
  this.iTimer = 0;
  this.iFactor = 1;
  this.KeyUp = Enums.Key.Up;
  this.KeyDown = Enums.Key.Down;
  this.KeyLeft = Enums.Key.Up;
  this.KeyRight = Enums.Key.Down;
  if (this.multiplyLineFactor) {
    if (this.multiplyLineFactor.subscribe) {
      this.multiplyLineFactor.subscribe(function (iValue) {
        this.iFactor = 0 < iValue ? iValue : 1;
      }, this);
    } else {
      this.iFactor = Types.pInt(this.multiplyLineFactor);
    }
    this.KeyUp = Enums.Key.Up;
    this.KeyDown = Enums.Key.Down;
    this.KeyLeft = Enums.Key.Left;
    this.KeyRight = Enums.Key.Right;
    if ($('html').hasClass('rtl')) {
      this.KeyLeft = Enums.Key.Right;
      this.KeyRight = Enums.Key.Left;
    }
  }
  this.sActionSelector = '';
  this.sSelectableSelector = '';
  this.sCheckboxSelector = '';
  var self = this;

  // reading returns a list of checked items.
  // recording (bool) puts all checked, or unchecked.
  this.listChecked = ko.computed({
    'read': function read() {
      var aList = _.filter(this.list(), function (oItem) {
        var bC = oItem && oItem.checked && oItem.checked(),
          bS = oItem && oItem.selected && oItem.selected();
        return bC || self.bCheckOnSelect && bS;
      });
      return aList;
    },
    'write': function write(bValue) {
      bValue = !!bValue;
      _.each(this.list(), function (oItem) {
        oItem.checked(bValue);
      });
      this.list.valueHasMutated();
    },
    'owner': this
  });
  this.checkAll = ko.computed({
    'read': function read() {
      return 0 < this.listChecked().length;
    },
    'write': function write(bValue) {
      this.listChecked(!!bValue);
    },
    'owner': this
  });
  this.selectorHook = ko.observable(null);
  this.selectorHook.subscribe(function () {
    if (this.active() && this.selectorHook()) {
      this.selectorHook().selected(false);
    }
  }, this, 'beforeChange');
  this.selectorHook.subscribe(function () {
    if (this.active() && this.selectorHook()) {
      this.selectorHook().selected(true);
    }
  }, this);
  this.itemSelected = ko.computed({
    'read': this.selectorHook,
    'write': function write(oItemToSelect) {
      this.selectorHook(oItemToSelect);
      if (oItemToSelect) {
        self.scrollToSelected();
        this.oLast = oItemToSelect;
      }
    },
    'owner': this
  });
  this.list.subscribe(function (list) {
    var selected = this.itemSelected();
    if (Array.isArray(list) && selected) {
      var hasSelected = !!list.find(function (item) {
        if (typeof selected.isEqual === 'function') {
          return selected.isEqual(item);
        }
        return selected === item;
      });
      if (!hasSelected) {
        this.itemSelected(null);
      }
    } else {
      this.itemSelected(null);
    }
  }, this);
  this.listCheckedOrSelected = ko.computed({
    'read': function read() {
      var oSelected = this.itemSelected(),
        aChecked = this.listChecked();
      return 0 < aChecked.length ? aChecked : oSelected ? [oSelected] : [];
    },
    'write': function write(bValue) {
      if (!bValue) {
        this.itemSelected(null);
        this.listChecked(false);
      } else {
        this.listChecked(true);
      }
    },
    'owner': this
  });
  this.listCheckedAndSelected = ko.computed({
    'read': function read() {
      var aResult = [],
        oSelected = this.itemSelected(),
        aChecked = this.listChecked();
      if (aChecked) {
        aResult = aChecked.slice(0);
      }
      if (oSelected && _.indexOf(aChecked, oSelected) === -1) {
        aResult.push(oSelected);
      }
      return aResult;
    },
    'write': function write(bValue) {
      if (!bValue) {
        this.itemSelected(null);
        this.listChecked(false);
      } else {
        this.listChecked(true);
      }
    },
    'owner': this
  });
  this.isIncompleteChecked = ko.computed(function () {
    var iM = this.list().length,
      iC = this.listChecked().length;
    return 0 < iM && 0 < iC && iM > iC;
  }, this);
  this.onKeydownBound = _.bind(this.onKeydown, this);
}
CSelector.prototype.iTimer = 0;
CSelector.prototype.bResetCheckedOnClick = false;
CSelector.prototype.bCheckOnSelect = false;
CSelector.prototype.bUnselectOnCtrl = false;
CSelector.prototype.bDisableMultiplySelection = false;
CSelector.prototype.getLastOrSelected = function () {
  var iCheckedCount = 0,
    oLastSelected = null;
  _.each(this.list(), function (oItem) {
    if (oItem && _.isFunction(oItem.checked)) {
      if (oItem.checked()) {
        iCheckedCount++;
      }
      if (oItem.selected()) {
        oLastSelected = oItem;
      }
    }
  });
  return 0 === iCheckedCount && oLastSelected ? oLastSelected : this.oLast;
};
CSelector.prototype.unbind = function () {
  this.active(false);
  if (this.itemSelected()) {
    this.itemSelected().selected(false);
  }
  $(document).off('keydown', this.onKeydownBound);
  $(this.oListScope).off();
};

/**
 * @param {string} sActionSelector css-selector for the active for pressing regions of the list
 * @param {string} sSelectableSelector css-selector to the item that was selected
 * @param {string} sCheckboxSelector css-selector to the element that checkbox in the list
 * @param {*} oListScope
 * @param {*} oScrollScope
 */
CSelector.prototype.initOnApplyBindings = function (sActionSelector, sSelectableSelector, sCheckboxSelector, oListScope, oScrollScope) {
  this.active(true);
  $(document).on('keydown', this.onKeydownBound);
  this.oListScope = oListScope;
  this.oScrollScope = oScrollScope;
  this.sActionSelector = sActionSelector;
  this.sSelectableSelector = sSelectableSelector;
  this.sCheckboxSelector = sCheckboxSelector;
  var self = this,
    fEventClickFunction = function fEventClickFunction(oLast, oItem, oEvent) {
      var iIndex = 0,
        iLength = 0,
        oListItem = null,
        bChangeRange = false,
        bIsInRange = false,
        aList = [],
        bChecked = false;
      oItem = oItem ? oItem : null;
      if (oEvent && oEvent.shiftKey) {
        if (null !== oItem && null !== oLast && oItem !== oLast) {
          aList = self.list();
          bChecked = oItem.checked();
          for (iIndex = 0, iLength = aList.length; iIndex < iLength; iIndex++) {
            oListItem = aList[iIndex];
            bChangeRange = false;
            if (oListItem === oLast || oListItem === oItem) {
              bChangeRange = true;
            }
            if (bChangeRange) {
              bIsInRange = !bIsInRange;
            }
            if ((bIsInRange || bChangeRange) && oListItem && oListItem.checked) {
              oListItem.checked(bChecked);
            }
          }
        }
      }
      if (oItem) {
        self.oLast = oItem;
      }
    };
  $(this.oListScope).on('dblclick', sActionSelector, function (oEvent) {
    var oItem = ko.dataFor(this);
    if (oItem && oEvent && !oEvent.ctrlKey && !oEvent.altKey && !oEvent.shiftKey) {
      self.onDblClick(oItem);
    }
  });
  if (Browser.mobileDevice) {
    $(this.oListScope).on('touchstart', sActionSelector, function (e) {
      if (!e) {
        return;
      }
      var t2 = e.timeStamp,
        t1 = $(this).data('lastTouch') || t2,
        dt = t2 - t1,
        fingers = e.originalEvent && e.originalEvent.touches ? e.originalEvent.touches.length : 0;
      $(this).data('lastTouch', t2);
      if (!dt || dt > 250 || fingers > 1) {
        return;
      }
      e.preventDefault();
      $(this).trigger('dblclick');
    });
  }
  $(this.oListScope).on('click', sActionSelector, function (oEvent) {
    var bClick = true,
      oSelected = null,
      oLast = self.getLastOrSelected(),
      oItem = ko.dataFor(this);
    if (oItem && oEvent) {
      if (oEvent.shiftKey) {
        bClick = false;
        if (!self.bDisableMultiplySelection) {
          if (null === self.oLast) {
            self.oLast = oItem;
          }
          oItem.checked(!oItem.checked());
          fEventClickFunction(oLast, oItem, oEvent);
        }
      } else if (oEvent.ctrlKey || oEvent.metaKey) {
        bClick = false;
        if (!self.bDisableMultiplySelection) {
          self.oLast = oItem;
          oSelected = self.itemSelected();
          if (oSelected && !oSelected.checked() && !oItem.checked()) {
            oSelected.checked(true);
          }
          if (self.bUnselectOnCtrl && oItem === self.itemSelected()) {
            oItem.checked(!oItem.selected());
            self.itemSelected(null);
          } else {
            oItem.checked(!oItem.checked());
          }
        }
      }
      if (bClick) {
        self.selectionFunc(oItem);
      }
    }
  });
  $(this.oListScope).on('click', sCheckboxSelector, function (oEvent) {
    var oItem = ko.dataFor(this);
    if (oItem && oEvent && !self.bDisableMultiplySelection) {
      if (oEvent.shiftKey) {
        if (null === self.oLast) {
          self.oLast = oItem;
        }
        fEventClickFunction(self.getLastOrSelected(), oItem, oEvent);
      } else {
        self.oLast = oItem;
      }
    }
    if (oEvent && oEvent.stopPropagation) {
      oEvent.stopPropagation();
    }
  });
  $(this.oListScope).on('dblclick', sCheckboxSelector, function (oEvent) {
    if (oEvent && oEvent.stopPropagation) {
      oEvent.stopPropagation();
    }
  });
};

/**
 * @param {Object} oSelected
 * @param {number} iEventKeyCode
 *
 * @return {Object}
 */
CSelector.prototype.getResultSelection = function (oSelected, iEventKeyCode) {
  var self = this,
    bStop = false,
    bNext = false,
    oResult = null,
    iPageStep = this.iFactor,
    bMultiply = !!this.multiplyLineFactor,
    iIndex = 0,
    iLen = 0,
    aList = [];
  if (!oSelected && -1 < $.inArray(iEventKeyCode, [this.KeyUp, this.KeyDown, this.KeyLeft, this.KeyRight, Enums.Key.PageUp, Enums.Key.PageDown, Enums.Key.Home, Enums.Key.End])) {
    aList = this.list();
    if (aList && 0 < aList.length) {
      if (-1 < $.inArray(iEventKeyCode, [this.KeyDown, this.KeyRight, Enums.Key.PageUp, Enums.Key.Home])) {
        oResult = aList[0];
      } else if (-1 < $.inArray(iEventKeyCode, [this.KeyUp, this.KeyLeft, Enums.Key.PageDown, Enums.Key.End])) {
        oResult = aList[aList.length - 1];
      }
    }
  } else if (oSelected) {
    aList = this.list();
    iLen = aList ? aList.length : 0;
    if (0 < iLen) {
      if (Enums.Key.Home === iEventKeyCode || Enums.Key.PageUp === iEventKeyCode || Enums.Key.End === iEventKeyCode || Enums.Key.PageDown === iEventKeyCode || bMultiply && (Enums.Key.Left === iEventKeyCode || Enums.Key.Right === iEventKeyCode) || !bMultiply && (Enums.Key.Up === iEventKeyCode || Enums.Key.Down === iEventKeyCode)) {
        _.each(aList, function (oItem) {
          if (!bStop) {
            switch (iEventKeyCode) {
              case self.KeyUp:
              case self.KeyLeft:
                if (oSelected === oItem) {
                  bStop = true;
                } else {
                  oResult = oItem;
                }
                break;
              case Enums.Key.Home:
              case Enums.Key.PageUp:
                oResult = oItem;
                bStop = true;
                break;
              case self.KeyDown:
              case self.KeyRight:
                if (bNext) {
                  oResult = oItem;
                  bStop = true;
                } else if (oSelected === oItem) {
                  bNext = true;
                }
                break;
              case Enums.Key.End:
              case Enums.Key.PageDown:
                oResult = oItem;
                break;
            }
          }
        });
      } else if (bMultiply && this.KeyDown === iEventKeyCode) {
        for (; iIndex < iLen; iIndex++) {
          if (oSelected === aList[iIndex]) {
            iIndex += iPageStep;
            if (iLen - 1 < iIndex) {
              iIndex -= iPageStep;
            }
            oResult = aList[iIndex];
            break;
          }
        }
      } else if (bMultiply && this.KeyUp === iEventKeyCode) {
        for (iIndex = iLen; iIndex >= 0; iIndex--) {
          if (oSelected === aList[iIndex]) {
            iIndex -= iPageStep;
            if (0 > iIndex) {
              iIndex += iPageStep;
            }
            oResult = aList[iIndex];
            break;
          }
        }
      }
    }
  }
  return oResult;
};

/**
 * @param {Object} oResult
 * @param {Object} oSelected
 * @param {number} iEventKeyCode
 */
CSelector.prototype.shiftClickResult = function (oResult, oSelected, iEventKeyCode) {
  if (oSelected) {
    var bMultiply = !!this.multiplyLineFactor,
      bInRange = false,
      bSelected = false;
    if (-1 < $.inArray(iEventKeyCode, bMultiply ? [Enums.Key.Left, Enums.Key.Right] : [Enums.Key.Up, Enums.Key.Down])) {
      oSelected.checked(!oSelected.checked());
    } else if (-1 < $.inArray(iEventKeyCode, bMultiply ? [Enums.Key.Up, Enums.Key.Down, Enums.Key.PageUp, Enums.Key.PageDown, Enums.Key.Home, Enums.Key.End] : [Enums.Key.Left, Enums.Key.Right, Enums.Key.PageUp, Enums.Key.PageDown, Enums.Key.Home, Enums.Key.End])) {
      bSelected = !oSelected.checked();
      _.each(this.list(), function (oItem) {
        var Add = false;
        if (oItem === oResult || oSelected === oItem) {
          bInRange = !bInRange;
          Add = true;
        }
        if (bInRange || Add) {
          oItem.checked(bSelected);
          Add = false;
        }
      });
      if (bMultiply && oResult && (iEventKeyCode === Enums.Key.Up || iEventKeyCode === Enums.Key.Down)) {
        oResult.checked(!oResult.checked());
      }
    }
  }
};

/**
 * @param {number} iEventKeyCode
 * @param {boolean} bShiftKey
 */
CSelector.prototype.clickNewSelectPosition = function (iEventKeyCode, bShiftKey) {
  var oSelected = this.itemSelected(),
    oResult = this.getResultSelection(oSelected, iEventKeyCode);
  if (oResult) {
    if (bShiftKey) {
      this.shiftClickResult(oResult, oSelected, iEventKeyCode);
    }
    this.selectionFunc(oResult);
  }
};

/**
 * @param {Object} oEvent
 *
 * @return {boolean}
 */
CSelector.prototype.onKeydown = function (oEvent) {
  var bResult = true,
    iCode = 0;
  if (this.useKeyboardKeys() && oEvent && !Utils.isTextFieldFocused() && !Popups.hasOpenedMaximizedPopups()) {
    iCode = oEvent.keyCode;
    if (!oEvent.ctrlKey && (this.KeyUp === iCode || this.KeyDown === iCode || this.KeyLeft === iCode || this.KeyRight === iCode || Enums.Key.PageUp === iCode || Enums.Key.PageDown === iCode || Enums.Key.Home === iCode || Enums.Key.End === iCode)) {
      this.clickNewSelectPosition(iCode, oEvent.shiftKey);
      bResult = false;
    } else if (Enums.Key.Del === iCode && !oEvent.ctrlKey && !oEvent.shiftKey) {
      if (0 < this.list().length) {
        this.onDelete();
        bResult = false;
      }
    } else if (Enums.Key.Enter === iCode) {
      if (0 < this.list().length && !oEvent.ctrlKey) {
        this.onEnter(this.itemSelected());
        bResult = false;
      }
    } else if (oEvent.ctrlKey && !oEvent.altKey && !oEvent.shiftKey && Enums.Key.a === iCode) {
      this.checkAll(!(this.checkAll() && !this.isIncompleteChecked()));
      bResult = false;
    }
  }
  return bResult;
};
CSelector.prototype.onDelete = function () {
  this.fDeleteCallback.call(this, this.listCheckedOrSelected());
};

/**
 * @param {Object} oItem
 */
CSelector.prototype.onEnter = function (oItem) {
  if (oItem) {
    this.fEnterCallback.call(this, oItem);
  }
};

/**
 * @param {Object} oItem
 */
CSelector.prototype.selectionFunc = function (oItem) {
  if (this.bChangeOnSelect) {
    this.itemSelected(null);
  }
  if (this.bResetCheckedOnClick) {
    this.listChecked(false);
  }
  if (this.bChangeOnSelect) {
    this.itemSelected(oItem);
  }
  this.fSelectCallback.call(this, oItem);
};

/**
 * @param {Object} oItem
 */
CSelector.prototype.onDblClick = function (oItem) {
  this.fDblClickCallback.call(this, oItem);
};
CSelector.prototype.koCheckAll = function () {
  return ko.computed({
    'read': this.checkAll,
    'write': this.checkAll,
    'owner': this
  });
};
CSelector.prototype.koCheckAllIncomplete = function () {
  return ko.computed({
    'read': this.isIncompleteChecked,
    'write': this.isIncompleteChecked,
    'owner': this
  });
};

/**
 * @return {boolean}
 */
CSelector.prototype.scrollToSelected = function () {
  if (!this.oListScope || !this.oScrollScope || !this.oScrollScope[0] || !this.oScrollScope[0].isConnected) {
    return false;
  }
  var iOffset = 20,
    oSelected = $(this.sSelectableSelector, this.oScrollScope),
    // oPos = oSelected.position(),
    offsetTop = oSelected[0] ? oSelected[0].offsetTop : undefined,
    iVisibleHeight = this.oScrollScope.height(),
    iScrollTop = this.oScrollScope.scrollTop(),
    iSelectedHeight = oSelected.outerHeight(),
    // bSelectedVisible = oPos && (oPos.top >= iScrollTop) && (oPos.top <= (iScrollTop + iVisibleHeight - iSelectedHeight))
    bSelectedVisible = offsetTop && offsetTop >= iScrollTop && offsetTop <= iScrollTop + iVisibleHeight - iSelectedHeight;
  if (!bSelectedVisible) {
    if (offsetTop < iScrollTop + iVisibleHeight && offsetTop + iSelectedHeight > iScrollTop + iVisibleHeight) {
      // selected item is partially visible from below
      // make it visible at bottom with offset
      this.oScrollScope.scrollTop(offsetTop + iSelectedHeight + iOffset - iVisibleHeight);
    } else {
      // make selected item visible at top with offset
      this.oScrollScope.scrollTop(offsetTop - iOffset);
    }
    return true;
  }
  return false;
};
module.exports = CSelector;

/***/ }),

/***/ "cR1d":
/*!***********************************************************!*\
  !*** ./modules/CoreWebclient/js/views/CHeaderItemView.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var ko = __webpack_require__(/*! knockout */ "p09A"),
  Routing = __webpack_require__(/*! modules/CoreWebclient/js/Routing.js */ "ioSH");
function CHeaderItemView(sLinkText) {
  this.sName = '';
  this.visible = ko.observable(true);
  this.baseHash = ko.observable('');
  this.hash = ko.observable('');
  this.linkText = ko.observable(sLinkText);
  this.isCurrent = ko.observable(false);
  this.recivedAnim = ko.observable(false).extend({
    'autoResetToFalse': 500
  });
  this.unseenCount = ko.observable(0);
  this.allowChangeTitle = ko.observable(false); // allows to change favicon and browser title when browser is inactive
  this.inactiveTitle = ko.observable('');
  this.excludedHashes = ko.observableArray([]);
}
CHeaderItemView.prototype.ViewTemplate = 'CoreWebclient_HeaderItemView';
CHeaderItemView.prototype.setName = function (sName) {
  this.sName = sName.toLowerCase();
  if (this.baseHash() === '') {
    this.hash(Routing.buildHashFromArray([sName.toLowerCase()]));
    this.baseHash(this.hash());
  } else {
    this.hash(this.baseHash());
  }
};
module.exports = CHeaderItemView;

/***/ }),

/***/ "ebd4":
/*!*******************************************************!*\
  !*** ./modules/CoreWebclient/js/models/CDateModel.js ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var moment = __webpack_require__(/*! moment */ "sdEb"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Utils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Common.js */ "uQaC"),
  UserSettings = __webpack_require__(/*! modules/CoreWebclient/js/Settings.js */ "KIwC");

/**
 * @constructor
 */
function CDateModel() {
  this.iTimeStampInUTC = 0;
  this.oMoment = null;
}

/**
 * @param {number} iTimeStampInUTC
 */
CDateModel.prototype.parse = function (iTimeStampInUTC) {
  this.iTimeStampInUTC = iTimeStampInUTC;
  this.oMoment = moment.unix(this.iTimeStampInUTC);
};

/**
 * @param {number} iYear
 * @param {number} iMonth
 * @param {number} iDay
 */
CDateModel.prototype.setDate = function (iYear, iMonth, iDay) {
  this.oMoment = moment([iYear, iMonth, iDay]);
};

/**
 * @return {string}
 */
CDateModel.prototype.getTimeFormat = function () {
  return UserSettings.timeFormat() === window.Enums.TimeFormat.F24 ? 'HH:mm' : 'hh:mm A';
};

/**
 * @return {string}
 */
CDateModel.prototype.getFullDate = function () {
  return this.getDate() + ' ' + this.getTime();
};

/**
 * @return {string}
 */
CDateModel.prototype.getMidDate = function () {
  return this.getShortDate(true);
};

/**
 * @param {boolean=} bTime = false
 * 
 * @return {string}
 */
CDateModel.prototype.getShortDate = function (bTime) {
  var sResult = '',
    oMomentNow = null;
  if (this.oMoment) {
    oMomentNow = moment();
    if (oMomentNow.format('L') === this.oMoment.format('L')) {
      sResult = this.oMoment.format(this.getTimeFormat());
    } else {
      if (oMomentNow.clone().subtract(1, 'days').format('L') === this.oMoment.format('L')) {
        sResult = TextUtils.i18n('COREWEBCLIENT/LABEL_YESTERDAY');
      } else {
        if (UserSettings.UserSelectsDateFormat) {
          sResult = this.oMoment.format(Utils.getDateFormatForMoment(UserSettings.dateFormat()));
        } else {
          if (oMomentNow.year() === this.oMoment.year()) {
            sResult = this.oMoment.format('MMM D');
          } else {
            sResult = this.oMoment.format('MMM D, YYYY');
          }
        }
      }
      if (!!bTime) {
        sResult += ', ' + this.oMoment.format(this.getTimeFormat());
      }
    }
  }
  return sResult;
};

/**
 * @return {string}
 */
CDateModel.prototype.getDate = function () {
  var sFormat = 'ddd, MMM D, YYYY';
  if (UserSettings.UserSelectsDateFormat) {
    sFormat = 'ddd, ' + Utils.getDateFormatForMoment(UserSettings.dateFormat());
  }
  return this.oMoment ? this.oMoment.format(sFormat) : '';
};

/**
 * @return {string}
 */
CDateModel.prototype.getTime = function () {
  return this.oMoment ? this.oMoment.format(this.getTimeFormat()) : '';
};

/**
 * @return {number}
 */
CDateModel.prototype.getTimeStampInUTC = function () {
  return this.iTimeStampInUTC;
};
module.exports = CDateModel;

/***/ }),

/***/ "hr1f":
/*!******************************************!*\
  !*** ./modules/CoreWebclient/js/CJua.js ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var $ = __webpack_require__(/*! jquery */ "M4cL"),
  _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  queue = __webpack_require__(/*! modules/CoreWebclient/js/vendors/queue.js */ "zbs1"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9"),
  App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
  UserSettings = __webpack_require__(/*! modules/CoreWebclient/js/Settings.js */ "KIwC"),
  Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "PMEU"),
  AlertPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/AlertPopup.js */ "Rjyw"),
  iDefLimit = UserSettings.MultipleFilesUploadLimit;
;
/**
 * @param {*} mValue
 * @return {boolean}
 */
function isUndefined(mValue) {
  return 'undefined' === typeof mValue;
}

/**
 * @param {*} oParent
 * @param {*} oDescendant
 *
 * @return {boolean}
 */
function contains(oParent, oDescendant) {
  var bResult = false;
  if (oParent && oDescendant) {
    if (oParent === oDescendant) {
      bResult = true;
    } else if (oParent.contains) {
      bResult = oParent.contains(oDescendant);
    } else {
      /*jshint bitwise: false*/
      bResult = oDescendant.compareDocumentPosition ? !!(oDescendant.compareDocumentPosition(oParent) & 8) : false;
      /*jshint bitwise: true*/
    }
  }
  return bResult;
}
function mainClearTimeout(iTimer) {
  if (0 < iTimer) {
    clearTimeout(iTimer);
  }
  iTimer = 0;
}

/**
 * @param {Event} oEvent
 * @return {?Event}
 */
function getEvent(oEvent) {
  oEvent = oEvent && (oEvent.originalEvent ? oEvent.originalEvent : oEvent) || window.event;
  return oEvent.dataTransfer ? oEvent : null;
}

/**
 * @param {Object} oValues
 * @param {string} sKey
 * @param {?} mDefault
 * @return {?}
 */
function getValue(oValues, sKey, mDefault) {
  return !oValues || !sKey || isUndefined(oValues[sKey]) ? mDefault : oValues[sKey];
}

/**
 * @param {Object} oOwner
 * @param {string} sPublicName
 * @param {*} mObject
 */
function setValue(oOwner, sPublicName, mObject) {
  oOwner[sPublicName] = mObject;
}

/**
 * @param {Function} fFunction
 * @param {Object=} oScope
 * @return {Function}
 */
function scopeBind(fFunction, oScope) {
  return function () {
    return fFunction.apply(isUndefined(oScope) ? null : oScope, Array.prototype.slice.call(arguments));
  };
}

/**
 * @param {number=} iLen
 * @return {string}
 */
function fakeMd5(iLen) {
  var sResult = '',
    sLine = '0123456789abcdefghijklmnopqrstuvwxyz';
  iLen = isUndefined(iLen) ? 32 : Types.pInt(iLen);
  while (sResult.length < iLen) {
    sResult += sLine.substr(Math.round(Math.random() * sLine.length), 1);
  }
  return sResult;
}

/**
 * @return {string}
 */
function getNewUid() {
  return 'jua-uid-' + fakeMd5(16) + '-' + new Date().getTime().toString();
}

/**
 * @param {*} oFile
 * @param {string=} sPath
 * @return {Object}
 */
function getDataFromFile(oFile, sPath) {
  var sFileName = isUndefined(oFile.fileName) ? isUndefined(oFile.name) ? null : oFile.name : oFile.fileName,
    iSize = isUndefined(oFile.fileSize) ? isUndefined(oFile.size) ? null : oFile.size : oFile.fileSize,
    sType = isUndefined(oFile.type) ? null : oFile.type;
  return {
    'FileName': sFileName,
    'Size': iSize,
    'Type': sType,
    'Folder': isUndefined(sPath) ? '' : sPath,
    'File': oFile
  };
}

/**
 * @param {*} aItems
 * @param {Function} fFileCallback
 * @param {boolean=} bEntry = false
 * @param {boolean=} bAllowFolderDragAndDrop = true
 * @param {Function=} fEmptyFolderCallback
 * @param {number=} iLimit = 20
 * @param {Function=} fLimitCallback
 */
function getDataFromFiles(aItems, fFileCallback, bEntry, bAllowFolderDragAndDrop, fEmptyFolderCallback, iLimit, fLimitCallback) {
  var iInputLimit = 0,
    iLen = 0,
    iIndex = 0,
    oItem = null,
    oEntry = null,
    bUseLimit = false,
    bCallLimit = false,
    _fTraverseFileTree = function fTraverseFileTree(oItem, sPath, fCallback, fLimitCallbackProxy) {
      if (oItem && !isUndefined(oItem['name'])) {
        sPath = sPath || '';
        if (oItem['isFile']) {
          oItem.file(function (oFile) {
            if (!bUseLimit || 0 <= --iLimit) {
              fCallback(getDataFromFile(oFile, sPath));
            } else if (bUseLimit && !bCallLimit) {
              if (0 > iLimit && fLimitCallback) {
                bCallLimit = true;
                fLimitCallback(iInputLimit);
              }
            }
          });
        } else if (bAllowFolderDragAndDrop && oItem['isDirectory'] && oItem['createReader']) {
          var oDirReader = oItem['createReader'](),
            iIndex = 0,
            iLen = 0;
          if (oDirReader && oDirReader['readEntries']) {
            oDirReader['readEntries'](function (aEntries) {
              if (aEntries && Types.isNonEmptyArray(aEntries)) {
                for (iIndex = 0, iLen = aEntries.length; iIndex < iLen; iIndex++) {
                  _fTraverseFileTree(aEntries[iIndex], sPath + oItem['name'] + '/', fCallback, fLimitCallbackProxy);
                }
              } else {
                fEmptyFolderCallback(oItem);
              }
            });
          }
        }
      }
    };
  bAllowFolderDragAndDrop = isUndefined(bAllowFolderDragAndDrop) ? true : !!bAllowFolderDragAndDrop;
  bEntry = isUndefined(bEntry) ? false : !!bEntry;
  iLimit = isUndefined(iLimit) ? iDefLimit : Types.pInt(iLimit);
  iInputLimit = iLimit;
  bUseLimit = 0 < iLimit;
  aItems = aItems && 0 < aItems.length ? aItems : null;
  if (aItems) {
    for (iIndex = 0, iLen = aItems.length; iIndex < iLen; iIndex++) {
      oItem = aItems[iIndex];
      if (oItem) {
        if (bEntry) {
          if ('file' === oItem['kind'] && oItem['webkitGetAsEntry']) {
            oEntry = oItem['webkitGetAsEntry']();
            if (oEntry) {
              _fTraverseFileTree(oEntry, '', fFileCallback, fLimitCallback);
            }
          }
        } else {
          if (!bUseLimit || 0 <= --iLimit) {
            fFileCallback(getDataFromFile(oItem));
          } else if (bUseLimit && !bCallLimit) {
            if (0 > iLimit && fLimitCallback) {
              bCallLimit = true;
              fLimitCallback(iInputLimit);
            }
          }
        }
      }
    }
  }
}

/**
 * @param {*} oInput
 * @param {Function} fFileCallback
 * @param {number=} iLimit = 20
 * @param {Function=} fLimitCallback
 */
function getDataFromInput(oInput, fFileCallback, iLimit, fLimitCallback) {
  var aFiles = oInput && oInput.files && 0 < oInput.files.length ? oInput.files : null;
  if (aFiles) {
    getDataFromFiles(aFiles, fFileCallback, false, false, function () {}, iLimit, fLimitCallback);
  } else {
    fFileCallback({
      'FileName': oInput.value.split('\\').pop().split('/').pop(),
      'Size': null,
      'Type': null,
      'Folder': '',
      'File': null
    });
  }
}
function eventContainsFiles(oEvent) {
  var bResult = false;
  if (oEvent && oEvent.dataTransfer && oEvent.dataTransfer.types && oEvent.dataTransfer.types.length) {
    var iIindex = 0,
      iLen = oEvent.dataTransfer.types.length;
    for (; iIindex < iLen; iIindex++) {
      if (oEvent.dataTransfer.types[iIindex].toLowerCase() === 'files') {
        bResult = true;
        break;
      }
    }
  }
  return bResult;
}

/**
 * @param {Event} oEvent
 * @param {Function} fFileCallback
 * @param {Function=} fEmptyFolderCallback
 * @param {number=} iLimit = 20
 * @param {Function=} fLimitCallback
 * @param {boolean=} bAllowFolderDragAndDrop = true
 */
function getDataFromDragEvent(oEvent, fFileCallback, fEmptyFolderCallback, iLimit, fLimitCallback, bAllowFolderDragAndDrop) {
  var aItems = null,
    aFiles = null;
  oEvent = getEvent(oEvent);
  if (oEvent) {
    aItems = (oEvent.dataTransfer ? getValue(oEvent.dataTransfer, 'items', null) : null) || getValue(oEvent, 'items', null);
    if (aItems && 0 < aItems.length && aItems[0] && aItems[0]['webkitGetAsEntry']) {
      getDataFromFiles(aItems, fFileCallback, true, bAllowFolderDragAndDrop, fEmptyFolderCallback, iLimit, fLimitCallback);
    } else if (eventContainsFiles(oEvent)) {
      aFiles = getValue(oEvent, 'files', null) || (oEvent.dataTransfer ? getValue(oEvent.dataTransfer, 'files', null) : null);
      if (aFiles && 0 < aFiles.length) {
        getDataFromFiles(aFiles, fFileCallback, false, false, fEmptyFolderCallback, iLimit, fLimitCallback);
      }
    }
  }
}
function createNextLabel() {
  return $('<label style="' + 'position: absolute; background-color:#fff; right: 0px; top: 0px; left: 0px; bottom: 0px; margin: 0px; padding: 0px; cursor: pointer;' + '"></label>').css({
    'opacity': 0
  });
}

/**
 * @param {string} sInputPos
 * @param {string=} sAccept = ''
 * @return {?Object}
 */
function createNextInput(sInputPos, sAccept) {
  if (sAccept !== '') {
    sAccept = ' accept="' + sAccept + '"';
  }
  return $('<input type="file" tabindex="-1" hidefocus="hidefocus" style="position: absolute; ' + sInputPos + ': -9999px;"' + sAccept + ' />');
}

/**
 * @param {string=} sName
 * @param {boolean=} bMultiple = true
 * @param {string=} sInputPos = 'left'
 * @param {string=} sAccept = ''
 * @return {?Object}
 */
function getNewInput(sName, bMultiple, sInputPos, sAccept) {
  sName = isUndefined(sName) ? '' : sName.toString();
  sInputPos = isUndefined(sInputPos) ? 'left' : sInputPos.toString();
  sAccept = isUndefined(sAccept) ? '' : sAccept.toString();
  var oLocal = createNextInput(sInputPos, sAccept);
  if (0 < sName.length) {
    oLocal.attr('name', sName);
  }
  if (isUndefined(bMultiple) ? true : bMultiple) {
    oLocal.prop('multiple', true);
  }
  return oLocal;
}

/**
 * @param {?} mStringOrFunction
 * @param {Array=} aFunctionParams
 * @return {string}
 */
function getStringOrCallFunction(mStringOrFunction, aFunctionParams) {
  return Types.pString(_.isFunction(mStringOrFunction) ? mStringOrFunction.apply(null, _.isArray(aFunctionParams) ? aFunctionParams : []) : mStringOrFunction);
}

/**
 * @constructor
 * @param {CJua} oJua
 * @param {Object} oOptions
 */
function AjaxDriver(oJua, oOptions) {
  this.oXhrs = {};
  this.oUids = {};
  this.oJua = oJua;
  this.oOptions = oOptions;
}

/**
 * @type {Object}
 */
AjaxDriver.prototype.oXhrs = {};

/**
 * @type {Object}
 */
AjaxDriver.prototype.oUids = {};

/**
 * @type {?CJua}
 */
AjaxDriver.prototype.oJua = null;

/**
 * @type {Object}
 */
AjaxDriver.prototype.oOptions = {};

/**
 * @return {boolean}
 */
AjaxDriver.prototype.isDragAndDropSupported = function () {
  return true;
};

/**
 * @param {string} sUid
 */
AjaxDriver.prototype.regTaskUid = function (sUid) {
  this.oUids[sUid] = true;
};

/**
 * @param {string} sUid
 * @param {object} oFileInfo
 * @param {object} oParsedHiddenParameters
 * @param {function} fCallback
 * @param {boolean} bSkipCompleteFunction
 * @param {boolean} bUseResponce
 * @param {number} iProgressOffset
 * @returns {Boolean}
 */
AjaxDriver.prototype.uploadTask = function (sUid, oFileInfo, oParsedHiddenParameters, fCallback, bSkipCompleteFunction, bUseResponce, iProgressOffset) {
  if (false === this.oUids[sUid] || !oFileInfo || !oFileInfo['File']) {
    fCallback(null, sUid);
    return false;
  }
  try {
    var self = this,
      oXhr = new XMLHttpRequest(),
      oFormData = new FormData(),
      sAction = getValue(this.oOptions, 'action', ''),
      aHidden = _.clone(getValue(this.oOptions, 'hidden', {})),
      fStartFunction = this.oJua.getEvent('onStart'),
      fCompleteFunction = this.oJua.getEvent('onComplete'),
      fProgressFunction = this.oJua.getEvent('onProgress');
    oXhr.open('POST', sAction, true);
    oXhr.setRequestHeader('X-Client', 'WebClient');
    oXhr.setRequestHeader('X-DeviceId', App.getCurrentDeviceId());
    if (fProgressFunction && oXhr.upload) {
      oXhr.upload.onprogress = function (oEvent) {
        if (oEvent && oEvent.lengthComputable && !isUndefined(oEvent.loaded) && !isUndefined(oEvent.total)) {
          if (typeof iProgressOffset === 'undefined') {
            fProgressFunction(sUid, oEvent.loaded, oEvent.total);
          } else {
            fProgressFunction(sUid, iProgressOffset + oEvent.loaded > oFileInfo.Size ? oFileInfo.Size : iProgressOffset + oEvent.loaded, oFileInfo.Size);
          }
        }
      };
    }
    oXhr.onreadystatechange = function () {
      if (4 === oXhr.readyState && 200 === oXhr.status) {
        if (fCompleteFunction && !bSkipCompleteFunction) {
          var bResult = false,
            oResult = null;
          try {
            oResult = $.parseJSON(oXhr.responseText);
            bResult = true;
          } catch (oException) {
            oResult = null;
          }
          fCompleteFunction(sUid, bResult, oResult);
        }
        if (!isUndefined(self.oXhrs[sUid])) {
          self.oXhrs[sUid] = null;
        }
        if (bUseResponce) {
          fCallback(oXhr.responseText, sUid);
        } else {
          fCallback(null, sUid);
        }
      } else {
        if (4 === oXhr.readyState) {
          fCompleteFunction(sUid, false, null);
          fCallback(null, sUid);
        }
      }
    };
    if (fStartFunction) {
      fStartFunction(sUid);
    }
    oFormData.append('jua-post-type', 'ajax');
    oFormData.append(getValue(this.oOptions, 'name', 'juaFile'), oFileInfo['File'], oFileInfo['FileName']);

    //extending jua hidden parameters with file hidden parameters
    oParsedHiddenParameters = _.extend(oParsedHiddenParameters, oFileInfo.Hidden || {});
    aHidden.Parameters = JSON.stringify(oParsedHiddenParameters);
    $.each(aHidden, function (sKey, mValue) {
      oFormData.append(sKey, getStringOrCallFunction(mValue, [oFileInfo]));
    });
    oXhr.send(oFormData);
    this.oXhrs[sUid] = oXhr;
    return true;
  } catch (oError) {
    if (window.console) {
      window.console.error(oError);
    }
  }
  fCallback(null, sUid);
  return false;
};
AjaxDriver.prototype.generateNewInput = function (oClickElement) {
  var self = this,
    oLabel = null,
    oInput = null;
  if (oClickElement) {
    oInput = getNewInput('', !getValue(this.oOptions, 'disableMultiple', false), getValue(this.oOptions, 'hiddenElementsPosition', 'left'), getValue(this.oOptions, 'accept', ''));
    oLabel = createNextLabel();
    oLabel.append(oInput);
    $(oClickElement).append(oLabel);
    oInput.on('click', function (event) {
      if (!self.oJua.bEnableButton) {
        event.preventDefault();
        return;
      }
      var fOn = self.oJua.getEvent('onDialog');
      if (fOn) {
        fOn();
      }
    }).on('change', function () {
      getDataFromInput(this, function (oFile) {
        self.oJua.addNewFile(oFile);
        self.generateNewInput(oClickElement);
        setTimeout(function () {
          oLabel.remove();
        }, 10);
      }, getValue(self.oOptions, 'multipleSizeLimit', iDefLimit), self.oJua.getEvent('onLimitReached'));
    });
  }
};
AjaxDriver.prototype.cancel = function (sUid) {
  this.oUids[sUid] = false;
  if (this.oXhrs[sUid]) {
    try {
      if (this.oXhrs[sUid].abort) {
        this.oXhrs[sUid].abort();
      }
    } catch (oError) {}
    this.oXhrs[sUid] = null;
  }
};

/**
 * @constructor
 * @param {CJua} oJua
 * @param {Object} oOptions
 */
function IframeDriver(oJua, oOptions) {
  this.oUids = {};
  this.oForms = {};
  this.oJua = oJua;
  this.oOptions = oOptions;
}

/**
 * @type {Object}
 */
IframeDriver.prototype.oUids = {};

/**
 * @type {Object}
 */
IframeDriver.prototype.oForms = {};

/**
 * @type {?CJua}
 */
IframeDriver.prototype.oJua = null;

/**
 * @type {Object}
 */
IframeDriver.prototype.oOptions = {};

/**
 * @return {boolean}
 */
IframeDriver.prototype.isDragAndDropSupported = function () {
  return false;
};

/**
 * @param {string} sUid
 */
IframeDriver.prototype.regTaskUid = function (sUid) {
  this.oUids[sUid] = true;
};

/**
 * @param {string} sUid
 * @param {object} oFileInfo
 * @param {object} oParsedHiddenParameters
 * @param {function} fCallback
 * @param {boolean} bSkipCompleteFunction
 * @param {boolean} bUseResponce
 * @param {number} iProgressOffset
 * @returns {Boolean}
 */
IframeDriver.prototype.uploadTask = function (sUid, oFileInfo, oParsedHiddenParameters, fCallback, bSkipCompleteFunction, bUseResponce, iProgressOffset) {
  if (false === this.oUids[sUid]) {
    fCallback(null, sUid);
    return false;
  }
  var oForm = this.oForms[sUid],
    aHidden = _.clone(getValue(this.oOptions, 'hidden', {})),
    fStartFunction = this.oJua.getEvent('onStart'),
    fCompleteFunction = this.oJua.getEvent('onComplete');
  if (oForm) {
    oForm.append($('<input type="hidden" />').attr('name', 'jua-post-type').val('iframe'));

    //extending jua hidden parameters with file hidden parameters
    oParsedHiddenParameters = _.extend(oParsedHiddenParameters, oFileInfo.Hidden || {});
    aHidden.Parameters = JSON.stringify(oParsedHiddenParameters);
    $.each(aHidden, function (sKey, sValue) {
      oForm.append($('<input type="hidden" />').attr('name', sKey).val(getStringOrCallFunction(sValue, [oFileInfo])));
    });
    oForm.trigger('submit');
    if (fStartFunction) {
      fStartFunction(sUid);
    }
    oForm.find('iframe').on('load', function (oEvent) {
      var bResult = false,
        oIframeDoc = null,
        oResult = {};
      if (fCompleteFunction) {
        try {
          oIframeDoc = this.contentDocument ? this.contentDocument : this.contentWindow.document;
          oResult = $.parseJSON(oIframeDoc.body.innerHTML);
          bResult = true;
        } catch (oErr) {
          oResult = {};
        }
        fCompleteFunction(sUid, bResult, oResult);
      }
      fCallback(null, sUid);
      window.setTimeout(function () {
        oForm.remove();
      }, 100);
    });
  } else {
    fCallback(null, sUid);
  }
  return true;
};
IframeDriver.prototype.generateNewInput = function (oClickElement) {
  var self = this,
    sUid = '',
    oInput = null,
    oIframe = null,
    sAction = getValue(this.oOptions, 'action', ''),
    oForm = null,
    sPos = getValue(this.oOptions, 'hiddenElementsPosition', 'left');
  if (oClickElement) {
    sUid = getNewUid();
    oInput = getNewInput(getValue(this.oOptions, 'name', 'juaFile'), !getValue(this.oOptions, 'disableMultiple', false), getValue(this.oOptions, 'hiddenElementsPosition', 'left'), getValue(this.oOptions, 'accept', ''));
    oForm = $('<form action="' + sAction + '" target="iframe-' + sUid + '" ' + ' method="POST" enctype="multipart/form-data" style="display: block; cursor: pointer;"></form>');
    oIframe = $('<iframe name="iframe-' + sUid + '" tabindex="-1" src="javascript:void(0);" ' + ' style="position: absolute; top: -1000px; ' + sPos + ': -1000px; cursor: pointer;" />').css({
      'opacity': 0
    });
    oForm.append(createNextLabel().append(oInput)).append(oIframe);
    $(oClickElement).append(oForm);
    this.oForms[sUid] = oForm;
    oInput.on('click', function (event) {
      if (!self.oJua.bEnableButton) {
        event.preventDefault();
        return;
      }
      var fOn = self.oJua.getEvent('onDialog');
      if (fOn) {
        fOn();
      }
    }).on('change', function () {
      getDataFromInput(this, function (oFile) {
        if (oFile) {
          var sPos = getValue(self.oOptions, 'hiddenElementsPosition', 'left');
          oForm.css({
            'position': 'absolute',
            'top': -1000
          });
          oForm.css(sPos, -1000);
          self.oJua.addFile(sUid, oFile);
          self.generateNewInput(oClickElement);
        }
      }, getValue(self.oOptions, 'multipleSizeLimit', iDefLimit), self.oJua.getEvent('onLimitReached'));
    });
  }
};
IframeDriver.prototype.cancel = function (sUid) {
  this.oUids[sUid] = false;
  if (this.oForms[sUid]) {
    this.oForms[sUid].remove();
    this.oForms[sUid] = false;
  }
};

/**
 * @constructor
 * @param {Object=} oOptions
 */
function CJua(oOptions) {
  oOptions = isUndefined(oOptions) ? {} : oOptions;
  var self = this;
  self.bEnableDnD = true;
  self.bEnableButton = true;
  self.oEvents = {
    'onDialog': null,
    'onSelect': null,
    'onStart': null,
    'onComplete': null,
    'onCompleteAll': null,
    'onProgress': null,
    'onDragEnter': null,
    'onDragLeave': null,
    'onDrop': null,
    'onEmptyFolderDrop': null,
    'onBodyDragEnter': null,
    'onBodyDragLeave': null,
    'onLimitReached': function onLimitReached() {
      Popups.showPopup(AlertPopup, [TextUtils.i18n('COREWEBCLIENT/ERROR_UPLOAD_NUMBER_LIMIT_PLURAL', {
        'NUMBERLIMIT': iDefLimit
      }, null, iDefLimit)]);
    }
  };
  self.oOptions = _.extend({
    'action': '',
    'name': '',
    'hidden': {},
    'queueSize': 10,
    'clickElement': false,
    'dragAndDropElement': false,
    'dragAndDropBodyElement': false,
    'disableAjaxUpload': false,
    'disableFolderDragAndDrop': true,
    'disableDragAndDrop': false,
    'disableMultiple': false,
    'disableDocumentDropPrevent': false,
    'disableAutoUploadOnDrop': false,
    'multipleSizeLimit': iDefLimit,
    'hiddenElementsPosition': 'left'
  }, oOptions);
  self.oQueue = queue(Types.pInt(getValue(self.oOptions, 'queueSize', 10)));
  if (self.runEvent('onCompleteAll')) {
    self.oQueue["await"](function () {
      self.runEvent('onCompleteAll');
    });
  }
  self.oDriver = self.isAjaxUploaderSupported() && !getValue(self.oOptions, 'disableAjaxUpload', false) ? new AjaxDriver(self, self.oOptions) : new IframeDriver(self, self.oOptions);
  self.oClickElement = getValue(self.oOptions, 'clickElement', null);
  if (self.oClickElement) {
    $(self.oClickElement).css({
      'position': 'relative',
      'overflow': 'hidden'
    });
    if ('inline' === $(this.oClickElement).css('display')) {
      $(this.oClickElement).css('display', 'inline-block');
    }
    this.oDriver.generateNewInput(this.oClickElement);
  }
  if (this.oDriver.isDragAndDropSupported() && getValue(this.oOptions, 'dragAndDropElement', false) && !getValue(this.oOptions, 'disableAjaxUpload', false)) {
    (function (self) {
      var $doc = $(document),
        oBigDropZone = $(getValue(self.oOptions, 'dragAndDropBodyElement', false) || $doc),
        oDragAndDropElement = getValue(self.oOptions, 'dragAndDropElement', false),
        fHandleDragOver = function fHandleDragOver(oEvent) {
          if (self.bEnableDnD && oEvent) {
            oEvent = getEvent(oEvent);
            if (oEvent && oEvent.dataTransfer && eventContainsFiles(oEvent)) {
              try {
                var sEffect = oEvent.dataTransfer.effectAllowed;
                mainClearTimeout(self.iDocTimer);
                oEvent.dataTransfer.dropEffect = sEffect === 'move' || sEffect === 'linkMove' ? 'move' : 'copy';
                oEvent.stopPropagation();
                oEvent.preventDefault();
                oBigDropZone.trigger('dragover', oEvent);
              } catch (oExc) {}
            }
          }
        },
        fHandleDrop = function fHandleDrop(oEvent) {
          if (self.bEnableDnD && oEvent) {
            oEvent = getEvent(oEvent);
            if (oEvent && eventContainsFiles(oEvent)) {
              oEvent.preventDefault();
              getDataFromDragEvent(oEvent, function (oFile) {
                if (oFile) {
                  if (getValue(self.oOptions, 'disableAutoUploadOnDrop', false)) {
                    self.runEvent('onDrop', [oFile, oEvent, function () {
                      self.addNewFile(oFile);
                      mainClearTimeout(self.iDocTimer);
                    }]);
                  } else {
                    self.runEvent('onDrop', [oFile, oEvent]);
                    self.addNewFile(oFile);
                    mainClearTimeout(self.iDocTimer);
                  }
                }
              }, self.getEvent('onEmptyFolderDrop'), getValue(self.oOptions, 'multipleSizeLimit', iDefLimit), self.getEvent('onLimitReached'), !getValue(self.oOptions, 'disableFolderDragAndDrop', true));
            }
          }
          self.runEvent('onDragLeave', [oEvent]);
        },
        fHandleDragEnter = function fHandleDragEnter(oEvent) {
          if (self.bEnableDnD && oEvent) {
            oEvent = getEvent(oEvent);
            if (oEvent && eventContainsFiles(oEvent)) {
              mainClearTimeout(self.iDocTimer);
              oEvent.preventDefault();
              self.runEvent('onDragEnter', [oDragAndDropElement, oEvent]);
            }
          }
        },
        fHandleDragLeave = function fHandleDragLeave(oEvent) {
          if (self.bEnableDnD && oEvent) {
            oEvent = getEvent(oEvent);
            if (oEvent) {
              var oRelatedTarget = document['elementFromPoint'] ? document['elementFromPoint'](oEvent['clientX'], oEvent['clientY']) : null;
              if (oRelatedTarget && contains(this, oRelatedTarget)) {
                return;
              }
              mainClearTimeout(self.iDocTimer);
              self.runEvent('onDragLeave', [oDragAndDropElement, oEvent]);
            }
            return;
          }
        };
      if (oDragAndDropElement) {
        if (!getValue(self.oOptions, 'disableDocumentDropPrevent', false)) {
          $doc.on('dragover', function (oEvent) {
            if (self.bEnableDnD && oEvent) {
              oEvent = getEvent(oEvent);
              if (oEvent && oEvent.dataTransfer && eventContainsFiles(oEvent)) {
                try {
                  oEvent.dataTransfer.dropEffect = 'none';
                  oEvent.preventDefault();
                } catch (oExc) {}
              }
            }
          });
        }
        if (oBigDropZone && oBigDropZone[0]) {
          oBigDropZone.on('dragover', function (oEvent) {
            if (self.bEnableDnD && oEvent) {
              mainClearTimeout(self.iDocTimer);
            }
          }).on('dragenter', function (oEvent) {
            if (self.bEnableDnD && oEvent) {
              oEvent = getEvent(oEvent);
              if (oEvent && eventContainsFiles(oEvent)) {
                mainClearTimeout(self.iDocTimer);
                oEvent.preventDefault();
                self.runEvent('onBodyDragEnter', [oEvent]);
              }
            }
          }).on('dragleave', function (oEvent) {
            if (self.bEnableDnD && oEvent) {
              oEvent = getEvent(oEvent);
              if (oEvent) {
                mainClearTimeout(self.iDocTimer);
                self.iDocTimer = setTimeout(function () {
                  self.runEvent('onBodyDragLeave', [oEvent]);
                }, 200);
              }
            }
          }).on('drop', function (oEvent) {
            if (self.bEnableDnD && oEvent) {
              oEvent = getEvent(oEvent);
              if (oEvent) {
                var bFiles = eventContainsFiles(oEvent);
                if (bFiles) {
                  oEvent.preventDefault();
                }
                self.runEvent('onBodyDragLeave', [oEvent]);
                return !bFiles;
              }
            }
            return false;
          });
        }
        $(oDragAndDropElement).bind('dragenter', fHandleDragEnter).bind('dragover', fHandleDragOver).bind('dragleave', fHandleDragLeave).bind('drop', fHandleDrop);
      }
    })(self);
  } else {
    self.bEnableDnD = false;
  }
  setValue(self, 'on', self.on);
  setValue(self, 'cancel', self.cancel);
  setValue(self, 'isDragAndDropSupported', self.isDragAndDropSupported);
  setValue(self, 'isAjaxUploaderSupported', self.isAjaxUploaderSupported);
  setValue(self, 'setDragAndDropEnabledStatus', self.setDragAndDropEnabledStatus);
}

/**
 * @type {boolean}
 */
CJua.prototype.bEnableDnD = true;

/**
 * @type {number}
 */
CJua.prototype.iDocTimer = 0;

/**
 * @type {Object}
 */
CJua.prototype.oOptions = {};

/**
 * @type {Object}
 */
CJua.prototype.oEvents = {};

/**
 * @type {?Object}
 */
CJua.prototype.oQueue = null;

/**
 * @type {?Object}
 */
CJua.prototype.oDriver = null;

/**
 * @param {string} sName
 * @param {Function} fFunc
 */
CJua.prototype.on = function (sName, fFunc) {
  this.oEvents[sName] = fFunc;
  return this;
};

/**
 * @param {string} sName
 * @param {string=} aArgs
 */
CJua.prototype.runEvent = function (sName, aArgs) {
  if (this.oEvents[sName]) {
    this.oEvents[sName].apply(null, aArgs || []);
  }
};

/**
 * @param {string} sName
 */
CJua.prototype.getEvent = function (sName) {
  return this.oEvents[sName] || null;
};

/**
 * @param {string} sUid
 */
CJua.prototype.cancel = function (sUid) {
  this.oDriver.cancel(sUid);
};

/**
 * @return {boolean}
 */
CJua.prototype.isAjaxUploaderSupported = function () {
  return function () {
    var oInput = document.createElement('input');
    oInput.type = 'file';
    return !!('XMLHttpRequest' in window && 'multiple' in oInput && 'FormData' in window && new XMLHttpRequest().upload && true);
  }();
};

/**
 * @param {boolean} bEnabled
 */
CJua.prototype.setDragAndDropEnabledStatus = function (bEnabled) {
  this.bEnableDnD = !!bEnabled;
};

/**
 * @return {boolean}
 */
CJua.prototype.isDragAndDropSupported = function () {
  return this.oDriver.isDragAndDropSupported();
};

/**
 * @param {Object} oFileInfo
 */
CJua.prototype.addNewFile = function (oFileInfo) {
  this.addFile(getNewUid(), oFileInfo);
};

/**
 * @param {string} sUid
 * @param {Object} oFileInfo
 */
CJua.prototype.addFile = function (sUid, oFileInfo) {
  var fOnSelect = this.getEvent('onSelect'),
    fOnChunkReadyCallback = null,
    bBreakUpload = false,
    aHidden = getValue(this.oOptions, 'hidden', {}),
    fCompleteFunction = this.getEvent('onComplete'),
    fRegularUploadFileCallback = _.bind(function (sUid, oFileInfo) {
      var aHidden = getValue(this.oOptions, 'hidden', {}),
        oParsedHiddenParameters = JSON.parse(getStringOrCallFunction(aHidden.Parameters, [oFileInfo]));
      this.oDriver.regTaskUid(sUid);
      this.oQueue.defer(scopeBind(this.oDriver.uploadTask, this.oDriver), sUid, oFileInfo, oParsedHiddenParameters);
    }, this),
    fCancelFunction = this.getEvent('onCancel');
  if (oFileInfo && (!fOnSelect || false !== fOnSelect(sUid, oFileInfo))) {
    // fOnChunkReadyCallback runs when chunk ready for uploading
    fOnChunkReadyCallback = _.bind(function (sUid, oFileInfo, fProcessNextChunkCallback, iCurrChunk, iChunkNumber, iProgressOffset) {
      var fOnUploadCallback = null;
      // fOnUploadCallback runs when server have responded for upload
      fOnUploadCallback = function fOnUploadCallback(sResponse, sFileUploadUid) {
        var oResponse = null;
        try {
          // Suppress exceptions in the connection failure case 
          oResponse = $.parseJSON(sResponse);
        } catch (err) {}
        if (oResponse && oResponse.Result && !oResponse.Result.Error && !oResponse.ErrorCode) {
          //if response contains result and have no errors
          fProcessNextChunkCallback(sUid, fOnChunkReadyCallback);
        } else if (oResponse && oResponse.Result && oResponse.Result.Error) {
          App.broadcastEvent('Jua::FileUploadingError');
          fCompleteFunction(sFileUploadUid, false, {
            ErrorCode: oResponse.Result.Error
          });
        } else if (oResponse && oResponse.ErrorCode) {
          App.broadcastEvent('Jua::FileUploadingError');
          fCompleteFunction(sFileUploadUid, false, {
            ErrorCode: oResponse.ErrorCode
          });
        } else {
          App.broadcastEvent('Jua::FileUploadingError');
          fCompleteFunction(sFileUploadUid, false);
        }
      };
      var aHidden = getValue(this.oOptions, 'hidden', {}),
        oParsedHiddenParameters = JSON.parse(getStringOrCallFunction(aHidden.Parameters, [oFileInfo]));
      this.oDriver.regTaskUid(sUid);
      this.oDriver.uploadTask(sUid, oFileInfo, oParsedHiddenParameters, fOnUploadCallback, iCurrChunk < iChunkNumber, true, iProgressOffset);
    }, this);
    var isUploadAvailable = ko.observable(true),
      oParsedHiddenParameters = JSON.parse(getStringOrCallFunction(aHidden.Parameters, [oFileInfo]));
    App.broadcastEvent('Jua::FileUpload::isUploadAvailable', {
      isUploadAvailable: isUploadAvailable,
      sModuleName: aHidden.Module,
      sUid: sUid,
      oFileInfo: oFileInfo
    });
    if (isUploadAvailable()) {
      bBreakUpload = App.broadcastEvent('Jua::FileUpload::before', {
        sUid: sUid,
        oFileInfo: oFileInfo,
        fOnChunkReadyCallback: fOnChunkReadyCallback,
        sModuleName: aHidden.Module,
        fRegularUploadFileCallback: fRegularUploadFileCallback,
        fCancelFunction: fCancelFunction,
        sStorageType: oParsedHiddenParameters.Type
      });
      if (bBreakUpload === false) {
        fRegularUploadFileCallback(sUid, oFileInfo);
      }
    } else if (_.isFunction(fCancelFunction)) {
      fCancelFunction(sUid);
    }
  } else {
    this.oDriver.cancel(sUid);
  }
};

/**
 * @param {string} sName
 * @param {mixed} mValue
 */
CJua.prototype.setOption = function (sName, mValue) {
  this.oOptions[sName] = mValue;
};
module.exports = CJua;

/***/ }),

/***/ "zbs1":
/*!***************************************************!*\
  !*** ./modules/CoreWebclient/js/vendors/queue.js ***!
  \***************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
!function () {
  function n(n) {
    function e() {
      for (; i = a < c.length && n > p;) {
        var u = a++,
          e = c[u],
          o = t.call(e, 1);
        o.push(l(u)), ++p, e[0].apply(null, o);
      }
    }
    function l(n) {
      return function (u, t) {
        --p, null == s && (null != u ? (s = u, a = d = 0 / 0, o()) : (c[n] = t, --d ? i || e() : o()));
      };
    }
    function o() {
      null != s ? m(s) : f ? m(s, c) : m.apply(null, [s].concat(c));
    }
    var r,
      i,
      f,
      c = [],
      a = 0,
      p = 0,
      d = 0,
      s = null,
      m = u;
    return n || (n = 1 / 0), r = {
      defer: function defer() {
        return s || (c.push(arguments), ++d, e()), r;
      },
      "await": function _await(n) {
        return m = n, f = !1, d || o(), r;
      },
      awaitAll: function awaitAll(n) {
        return m = n, f = !0, d || o(), r;
      }
    };
  }
  function u() {}
  var t = [].slice;
  n.version = "1.0.7",  true ? !(__WEBPACK_AMD_DEFINE_RESULT__ = (function () {
    return n;
  }).call(exports, __webpack_require__, exports, module),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : 0;
}();

/***/ })

}]);