"use strict";
(self["webpackChunkafterlogic_aurora_platform"] = self["webpackChunkafterlogic_aurora_platform"] || []).push([[8],{

/***/ "2KI4":
/*!********************************************!*\
  !*** ./modules/FilesWebclient/js/enums.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  Enums = {};

/**
 * @enum {number}
 */
Enums.FileStorageType = {
  'Personal': 'personal',
  'Corporate': 'corporate',
  'Shared': 'shared',
  'GoogleDrive': 'google',
  'Dropbox': 'dropbox',
  'Encrypted': 'encrypted',
  'Trash': 'trash',
  'Favorites': 'favorites'
};

/**
 * @enum {number}
 */
Enums.FileStorageLinkType = {
  'Unknown': 0,
  'GoogleDrive': 1,
  'Dropbox': 2,
  'YouTube': 3,
  'Vimeo': 4,
  'SoundCloud': 5
};

/**
 * @enum {number}
 */
Enums.SharedFileAccess = {
  'NoAccess': 0,
  'Write': 1,
  'Read': 2,
  'Reshare': 3
};

/**
 * @enum {number}
 */
Enums.FilesSortField = {
  'Filename': 0,
  'Size': 1,
  'Modified': 2
};
if (typeof window.Enums === 'undefined') {
  window.Enums = {};
}
_.extendOwn(window.Enums, Enums);

/***/ }),

/***/ "2dqB":
/*!*********************************************************!*\
  !*** ./modules/FilesWebclient/js/popups/RenamePopup.js ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av");

/**
 * @constructor
 */
function CRenamePopup() {
  CAbstractPopup.call(this);
  this.fCallback = null;
  this.name = ko.observable('');
  this.focused = ko.observable(false);
  this.error = ko.observable('');
  this.name.subscribe(function () {
    this.error('');
  }, this);
}
_.extendOwn(CRenamePopup.prototype, CAbstractPopup.prototype);
CRenamePopup.prototype.PopupTemplate = 'FilesWebclient_RenamePopup';

/**
 * @param {string} sName
 * @param {function} fCallback
 */
CRenamePopup.prototype.onOpen = function (sName, fCallback) {
  this.fCallback = fCallback;
  this.name(sName);
  this.focused(true);
  this.error('');
};
CRenamePopup.prototype.onOKClick = function () {
  this.error('');
  if (_.isFunction(this.fCallback)) {
    var sError = this.fCallback(this.name());
    if (sError) {
      this.error(sError);
    } else {
      // delay is necessary to avoid viewing an image on enter pressed here
      setTimeout(function () {
        this.closePopup();
      }.bind(this));
    }
  } else {
    setTimeout(function () {
      this.closePopup();
    }.bind(this));
  }
};
module.exports = new CRenamePopup();

/***/ }),

/***/ "5njy":
/*!*******************************************!*\
  !*** ./modules/FilesWebclient/js/Ajax.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var Ajax = __webpack_require__(/*! modules/CoreWebclient/js/Ajax.js */ "8QQh"),
  Settings = __webpack_require__(/*! modules/FilesWebclient/js/Settings.js */ "aSuo");
Ajax.registerAbortRequestHandler(Settings.ServerModuleName, function (oRequest, oOpenedRequest) {
  switch (oRequest.Method) {
    case 'GetFiles':
      return oOpenedRequest.Method === 'GetFiles';
  }
  return false;
});
module.exports = {
  send: function send(sMethod, oParameters, fResponseHandler, oContext) {
    Ajax.send(Settings.ServerModuleName, sMethod, oParameters, fResponseHandler, oContext);
  },
  sendToWebclient: function sendToWebclient(sMethod, oParameters, fResponseHandler, oContext) {
    Ajax.send('FilesWebclient', sMethod, oParameters, fResponseHandler, oContext);
  }
};

/***/ }),

/***/ "FTUa":
/*!**********************************************!*\
  !*** ./modules/FilesWebclient/js/manager.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



module.exports = function (oAppData) {
  __webpack_require__(/*! modules/FilesWebclient/js/enums.js */ "2KI4");
  var $ = __webpack_require__(/*! jquery */ "M4cL"),
    App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
    ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
    TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
    Settings = __webpack_require__(/*! modules/FilesWebclient/js/Settings.js */ "aSuo");
  var HeaderItemView = null,
    aToolbarButtons = [],
    filesViewInstance = null;
  var getFilesViewInstance = function getFilesViewInstance() {
    if (!filesViewInstance) {
      var CFilesView = __webpack_require__(/*! modules/FilesWebclient/js/views/CFilesView.js */ "v0iR");
      filesViewInstance = new CFilesView();
      if (!App.isPublic()) {
        filesViewInstance.registerToolbarButtons(aToolbarButtons);
        aToolbarButtons = [];
      }
    }
    return filesViewInstance;
  };
  Settings.init(oAppData);
  if (!ModulesManager.isModuleAvailable(Settings.ServerModuleName) || !App.isPublic() && Settings.Storages.length === 0) {
    return null;
  }
  if (App.isPublic()) {
    return {
      getScreens: function getScreens() {
        var oScreens = {};
        oScreens[Settings.HashModuleName] = getFilesViewInstance;
        return oScreens;
      }
    };
  } else if (App.isUserNormalOrTenant()) {
    if (App.isNewTab()) {
      return {
        getSelectFilesPopup: function getSelectFilesPopup() {
          return __webpack_require__(/*! modules/FilesWebclient/js/popups/SelectFilesPopup.js */ "jkTn");
        }
      };
    } else {
      return {
        start: function start(ModulesManager) {
          if (Settings.ShowCommonSettings || Settings.ShowFilesApps) {
            ModulesManager.run('SettingsWebclient', 'registerSettingsTab', [function () {
              return __webpack_require__(/*! modules/FilesWebclient/js/views/FilesSettingsFormView.js */ "lfpz");
            }, Settings.HashModuleName, TextUtils.i18n('FILESWEBCLIENT/LABEL_SETTINGS_TAB')]);
          }
          App.broadcastEvent('RegisterNewItemElement', {
            'title': TextUtils.i18n('FILESWEBCLIENT/ACTION_UPLOAD_FILES'),
            'handler': function handler() {
              // check if we are on contacts screen or not
              if (!window.location.hash.startsWith('#' + Settings.HashModuleName)) {
                window.location.hash = Settings.HashModuleName;
              }
              var filesViewInstance = getFilesViewInstance();
              function clickUploaderButton() {
                var input = filesViewInstance.uploaderButton().find('input')[0];
                if (input) {
                  input.click();
                  // in case of Upload Button it's needed to emulate click on the button to close the menu
                  setTimeout(function () {
                    $('.tabsbar .new_button_panel')[0].click();
                  }, 0);
                }
              }
              if (filesViewInstance.isCreateAllowed()) {
                if (filesViewInstance.uploaderButton() && filesViewInstance.uploaderButton().find('input').length) {
                  clickUploaderButton();
                } else {
                  var uploaderButtonSubscription = filesViewInstance.uploaderButton.subscribe(function () {
                    // Using setTimeout to ensure the DOM is updated before triggering the click
                    setTimeout(function () {
                      clickUploaderButton();
                      uploaderButtonSubscription.dispose();
                    }, 0);
                  });
                }
              }
            },
            'className': 'item_files',
            'order': 1,
            'column': 2
          });
          App.broadcastEvent('RegisterNewItemElement', {
            'title': TextUtils.i18n('FILESWEBCLIENT/ACTION_NEW_FOLDER'),
            'handler': function handler() {
              // check if we are on contacts screen or not
              if (!window.location.hash.startsWith('#' + Settings.HashModuleName)) {
                window.location.hash = Settings.HashModuleName;
              }
              var filesViewInstance = getFilesViewInstance();
              var command = filesViewInstance.createFolderCommand;
              if (command.canExecute()) {
                command();
              }
            },
            'className': 'item_folder',
            'order': 5,
            'column': 2
          });
        },
        getScreens: function getScreens() {
          var oScreens = {};
          oScreens[Settings.HashModuleName] = getFilesViewInstance;
          return oScreens;
        },
        getHeaderItem: function getHeaderItem() {
          if (HeaderItemView === null) {
            var CHeaderItemView = __webpack_require__(/*! modules/CoreWebclient/js/views/CHeaderItemView.js */ "cR1d"),
              sTabTitle = Settings.CustomTabTitle !== '' ? Settings.CustomTabTitle : TextUtils.i18n('FILESWEBCLIENT/ACTION_SHOW_FILES');
            HeaderItemView = new CHeaderItemView(sTabTitle);
          }
          return {
            item: HeaderItemView,
            name: Settings.HashModuleName
          };
        },
        getSelectFilesPopup: function getSelectFilesPopup() {
          return __webpack_require__(/*! modules/FilesWebclient/js/popups/SelectFilesPopup.js */ "jkTn");
        },
        getMobileSyncSettingsView: function getMobileSyncSettingsView() {
          return __webpack_require__(/*! modules/FilesWebclient/js/views/MobileSyncSettingsView.js */ "vV+s");
        },
        getFileConstructor: function getFileConstructor(oFile) {
          return __webpack_require__(/*! modules/FilesWebclient/js/models/CFileModel.js */ "8ri2");
        },
        addFileToCurrentFolder: function addFileToCurrentFolder(oFile) {
          if (filesViewInstance) {
            filesViewInstance.addFileToCurrentFolder(oFile);
          }
        },
        refresh: function refresh() {
          if (filesViewInstance) {
            filesViewInstance.refresh();
          }
        },
        registerToolbarButtons: function registerToolbarButtons(oToolbarButtons) {
          if (filesViewInstance) {
            filesViewInstance.registerToolbarButtons([oToolbarButtons]);
          } else {
            aToolbarButtons.push(oToolbarButtons);
          }
        }
      };
    }
  }
  return null;
};

/***/ }),

/***/ "Ui65":
/*!**************************************************!*\
  !*** ./modules/FilesWebclient/js/utils/Links.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9"),
  Settings = __webpack_require__(/*! modules/FilesWebclient/js/Settings.js */ "aSuo"),
  sSrchPref = 's.',
  sPthPref = 'p.',
  LinksUtils = {};

/**
 * Returns true if parameter contains path value.
 * @param {string} sTemp
 * @return {boolean}
 */
function IsPathParam(sTemp) {
  return sPthPref === sTemp.substr(0, sPthPref.length);
}
;

/**
 * Returns true if parameter contains search value.
 * @param {string} sTemp
 * @return {boolean}
 */
function IsSearchParam(sTemp) {
  return sSrchPref === sTemp.substr(0, sSrchPref.length);
}
;

/**
 * @param {string=} sStorage
 * @param {string=} sPath
 * @param {string=} sSearch
 * @param {object=} custom
 * @returns {Array}
 */
LinksUtils.getFiles = function (sStorage, sPath, sSearch) {
  var custom = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
  var aParams = [Settings.HashModuleName];
  if (sStorage && sStorage !== '') {
    aParams.push(sStorage);
  }
  if (sPath && sPath !== '') {
    aParams.push(sPthPref + sPath);
  }
  if (sSearch && sSearch !== '') {
    aParams.push(sSrchPref + sSearch);
  }
  if (custom && custom.prefix) {
    aParams.push(custom.prefix + custom.value);
  }
  return aParams;
};

/**
 * @param {Array} aParam
 * 
 * @return {Object}
 */
LinksUtils.parseFiles = function (aParam) {
  var iIndex = 0,
    sStorage = 'personal',
    sPath = '',
    sSearch = '';
  if (Types.isNonEmptyArray(aParam)) {
    if (aParam.length > iIndex && !IsPathParam(aParam[iIndex])) {
      sStorage = Types.pString(aParam[iIndex]);
      iIndex++;
    }
    if (aParam.length > iIndex && IsPathParam(aParam[iIndex])) {
      sPath = Types.pString(aParam[iIndex].substr(sPthPref.length));
      iIndex++;
    }
    if (aParam.length > iIndex && IsSearchParam(aParam[iIndex])) {
      sSearch = Types.pString(aParam[iIndex].substr(sSrchPref.length));
      iIndex++;
    }
  }
  return LinksUtils.getParsedParams(sStorage, sPath, sSearch, aParam[iIndex]);
};
LinksUtils.getParsedParams = function (sStorage, sPath, sSearch) {
  var custom = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
  var aPath = [],
    sName = '';
  if (Types.isNonEmptyString(sPath)) {
    aPath = _.without(sPath.split(/(?:\/|\$ZIP\:)/g), '');
    sName = aPath[aPath.length - 1];
  } else {
    sPath = '';
  }
  return {
    'Storage': sStorage,
    'Path': sPath,
    'PathParts': aPath,
    'Name': sName,
    'Search': sSearch,
    'Custom': custom
  };
};
module.exports = LinksUtils;

/***/ }),

/***/ "WJcO":
/*!***************************************************************!*\
  !*** ./modules/FilesWebclient/js/popups/CreateFolderPopup.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av");

/**
 * @constructor
 */
function CCreateFolderPopup() {
  CAbstractPopup.call(this);
  this.fCallback = null;
  this.folderName = ko.observable('');
  this.folderName.focus = ko.observable(false);
  this.folderName.error = ko.observable('');
  this.folderName.subscribe(function () {
    this.folderName.error('');
  }, this);
}
_.extendOwn(CCreateFolderPopup.prototype, CAbstractPopup.prototype);
CCreateFolderPopup.prototype.PopupTemplate = 'FilesWebclient_CreateFolderPopup';

/**
 * @param {Function} fCallback
 */
CCreateFolderPopup.prototype.onOpen = function (fCallback) {
  this.folderName('');
  this.folderName.focus(true);
  this.folderName.error('');
  if (_.isFunction(fCallback)) {
    this.fCallback = fCallback;
  }
};
CCreateFolderPopup.prototype.onOKClick = function () {
  this.folderName.error('');
  if (this.fCallback) {
    var sError = this.fCallback(this.folderName());
    if (sError) {
      this.folderName.error('' + sError);
    } else {
      // delay is necessary to avoid viewing an image on enter pressed here
      setTimeout(function () {
        this.closePopup();
      }.bind(this));
    }
  } else {
    setTimeout(function () {
      this.closePopup();
    }.bind(this));
  }
};
module.exports = new CCreateFolderPopup();

/***/ }),

/***/ "a2fk":
/*!**********************************************************!*\
  !*** ./modules/FilesWebclient/js/models/CFolderModel.js ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9"),
  App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
  CAbstractFileModel = __webpack_require__(/*! modules/CoreWebclient/js/models/CAbstractFileModel.js */ "LIBG"),
  CDateModel = __webpack_require__(/*! modules/CoreWebclient/js/models/CDateModel.js */ "ebd4"),
  ExtendedPropsPrototype = __webpack_require__(/*! modules/FilesWebclient/js/models/ExtendedPropsPrototype.js */ "pJZ0");

/**
 * @constructor
 * @param {object} oParent
 */
function CFolderModel(oParent) {
  this.oParent = oParent;
  // the constant is used instead of constructor.name because constructor.name can not be used in minified JS
  this.IS_FOLDER = true;

  //template
  this.selected = ko.observable(false);
  this.checked = ko.observable(false); // ? = selected ?
  this.deleted = ko.observable(false); // temporary removal until it was confirmation from the server to delete, css-animation
  this.recivedAnim = ko.observable(false).extend({
    'autoResetToFalse': 500
  });
  this.published = ko.observable(false);
  this.fileName = ko.observable('');
  this.sLastModified = 0;
  this.iLastModified = 0;

  //onDrop
  this.fullPath = ko.observable('');

  //rename
  this.path = ko.observable('');

  //pathItems
  this.storageType = ko.observable(Enums.FileStorageType.Personal);
  this.id = ko.observable('');
  this.sMainAction = 'list';
  this.sOwnerName = '';
  this.sInitiator = '';
  this.oExtendedProps = {};
  this.sharedWithMeAccessReshare = ko.observable(false);
  this.sharedWithMeAccessWrite = ko.observable(false);
  this.sharedWithMe = ko.observable(false);
  this.sharedWithOthers = ko.observable(false); // can be changed by other modules
  this.favorite = ko.observable(false);
  this.readOnly = ko.computed(function () {
    // save mail attachment to files functionality needs this CSS class
    return this.sharedWithMe() && !this.sharedWithMeAccessWrite();
  }, this);

  // The folder can be uploading. Operations should be disabled for such a folder.
  this.uploadingFilesCount = ko.observable(0);
  this.uploadedFilesCount = ko.observable(0);
  this.progressPercent = ko.computed(function () {
    if (this.uploadingFilesCount() > 0) {
      return Math.floor(this.uploadedFilesCount() / this.uploadingFilesCount() * 100);
    }
    return 0;
  }, this);
  this.isIncomplete = ko.computed(function () {
    return this.uploadingFilesCount() > 0;
  }, this);
  this.uploaded = ko.computed(function () {
    return this.uploadingFilesCount() === 0;
  }, this);
  this.allowDrag = ko.computed(function () {
    return !oParent.bInPopup && !this.isIncomplete() && !App.isPublic();
  }, this);
  this.allowDrop = ko.computed(function () {
    if (!this.oParent.bInPopup && !this.isIncomplete()) {
      var sharedParentFolder = this.oParent.sharedParentFolder();
      if (sharedParentFolder) {
        return sharedParentFolder.sharedWithMeAccessWrite();
      } else if (this.storageType() !== Enums.FileStorageType.Shared) {
        return !this.sharedWithMe() || this.sharedWithMeAccessWrite() && (!this.oParent.selectedHasShared() || this.oParent.needToCopyDraggedItems());
      }
    }
    return false;
  }, this);
}
_.extendOwn(CFolderModel.prototype, ExtendedPropsPrototype);
CFolderModel.prototype.parse = function (oData) {
  this.published(!!oData.Published);
  this.fileName(Types.pString(oData.Name));
  this.fullPath(Types.pString(oData.FullPath));
  this.path(Types.pString(oData.Path));
  this.storageType(Types.pString(oData.Type));
  this.id(Types.pString(oData.Id));
  this.favorite(Types.pBool(oData.IsFavorite));
  if (oData.MainAction) {
    this.sMainAction = Types.pString(oData.MainAction);
  }
  this.sLastModified = CFolderModel.parseLastModified(oData.LastModified);
  this.iLastModified = Types.pInt(oData.LastModified);
  this.sOwnerName = Types.pString(oData.Owner);
  this.sInitiator = Types.pString(oData.Initiator, this.sOwnerName);
  this.oExtendedProps = Types.pObject(oData.ExtendedProps);
  this.parseExtendedProps();
  this.displayName = ko.computed(function () {
    if (this.storageType() === Enums.FileStorageType.Shared && !this.oParent.sharedParentFolder()) {
      return this.fullPath().replace(/^\//, '');
    }
    return this.fileName();
  }, this);
  this.sHeaderText = function () {
    if (this.sharedWithMe() && this.sInitiator) {
      return TextUtils.i18n('FILESWEBCLIENT/INFO_SHARED_BY', {
        'OWNER': this.sInitiator
      });
    }
    return '';
  }.bind(this)();
  App.broadcastEvent('FilesWebclient::ParseFolder::after', [this, oData]);
};

/**
 * Parses date of last file modification.
 * @param {number} iLastModified Date in unix fomat
 * @returns {String}
 */
CFolderModel.parseLastModified = function (iLastModified) {
  var oDateModel = new CDateModel();
  if (iLastModified) {
    oDateModel.parse(iLastModified);
    return oDateModel.getShortDate();
  }
  return '';
};
CFolderModel.prototype.getMainAction = function () {
  return this.sMainAction;
};
CFolderModel.prototype.increaseUploadingFiles = function () {
  return this.uploadingFilesCount(this.uploadingFilesCount() + 1);
};
CFolderModel.prototype.increaseUploadedFiles = function () {
  return this.uploadedFilesCount(this.uploadedFilesCount() + 1);
};
CFolderModel.prototype.eventDragStart = CAbstractFileModel.prototype.eventDragStart;
module.exports = CFolderModel;

/***/ }),

/***/ "aSuo":
/*!***********************************************!*\
  !*** ./modules/FilesWebclient/js/Settings.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9");
module.exports = {
  ServerModuleName: 'Files',
  CorporateServerModuleName: 'CorporateFiles',
  PersonalServerModuleName: 'PersonalFiles',
  HashModuleName: 'files',
  Storages: [],
  EnableUploadSizeLimit: false,
  PublicFolderName: '',
  PublicHash: '',
  UploadSizeLimitMb: 0,
  UserSpaceLimitMb: 0,
  TenantSpaceLimitMb: 0,
  CorporateSpaceLimitMb: 0,
  AllowTrash: false,
  AllowFavorites: false,
  EditFileNameWithoutExtension: false,
  ShowCommonSettings: true,
  ShowFilesApps: true,
  BottomLeftCornerLinks: [],
  CustomTabTitle: '',
  ShowPersonalFilesAdminSection: false,
  ShowCorporateFilesAdminSection: false,
  PublicLinksEnabled: true,
  Sorting: {
    Allow: false
  },
  /**
   * Initializes settings from AppData object sections.
   *
   * @param {Object} oAppData Object contained modules settings.
   */
  init: function init(oAppData) {
    var oAppDataFilesSection = oAppData[this.ServerModuleName],
      // oAppDataPersonalFilesSection = oAppData[this.PersonalServerModuleName],
      oAppDataCorporateFilesSection = oAppData[this.CorporateServerModuleName],
      oAppDataFilesWebclientSection = oAppData['FilesWebclient'];
    if (!_.isEmpty(oAppDataFilesSection)) {
      this.Storages = Types.pArray(oAppDataFilesSection.Storages, this.Storages);
      this.EnableUploadSizeLimit = Types.pBool(oAppDataFilesSection.EnableUploadSizeLimit, this.EnableUploadSizeLimit);
      this.PublicFolderName = Types.pString(oAppDataFilesSection.PublicFolderName, this.PublicFolderName);
      this.PublicHash = Types.pString(oAppDataFilesSection.PublicHash, this.PublicHash);
      this.UploadSizeLimitMb = Types.pNonNegativeInt(oAppDataFilesSection.UploadSizeLimitMb, this.UploadSizeLimitMb);
      this.UserSpaceLimitMb = Types.pNonNegativeInt(oAppDataFilesSection.UserSpaceLimitMb, this.UserSpaceLimitMb);
      this.TenantSpaceLimitMb = Types.pNonNegativeInt(oAppDataFilesSection.TenantSpaceLimitMb, this.TenantSpaceLimitMb);
      this.AllowTrash = Types.pBool(oAppDataFilesSection.AllowTrash, this.AllowTrash);
      this.AllowFavorites = Types.pBool(oAppDataFilesSection.AllowFavorites, this.AllowFavorites);
      // this.EFilesSortField = Types.pObject(oAppDataFilesSection.SortField);
    }

    // if (!_.isEmpty(oAppDataPersonalFilesSection))
    // {
    this.ShowPersonalFilesAdminSection = true;
    // }

    if (!_.isEmpty(oAppDataCorporateFilesSection)) {
      this.ShowCorporateFilesAdminSection = true;
      this.CorporateSpaceLimitMb = Types.pNonNegativeInt(oAppDataCorporateFilesSection.SpaceLimitMb, this.CorporateSpaceLimitMb);
    }
    if (!_.isEmpty(oAppDataFilesWebclientSection)) {
      this.EditFileNameWithoutExtension = Types.pBool(oAppDataFilesWebclientSection.EditFileNameWithoutExtension, this.EditFileNameWithoutExtension);
      this.ShowCommonSettings = Types.pBool(oAppDataFilesWebclientSection.ShowCommonSettings, this.ShowCommonSettings);
      this.ShowFilesApps = Types.pBool(oAppDataFilesWebclientSection.ShowFilesApps, this.ShowFilesApps);
      this.BottomLeftCornerLinks = Types.pArray(oAppDataFilesWebclientSection.BottomLeftCornerLinks, this.BottomLeftCornerLinks);
      this.PublicLinksEnabled = Types.pBool(oAppDataFilesWebclientSection.PublicLinksEnabled, this.PublicLinksEnabled);
      this.Sorting = this.getSortConfig(Types.pObject(oAppDataFilesWebclientSection.FilesSortBy));
      this.CustomTabTitle = Types.pString(oAppDataFilesWebclientSection.CustomTabTitle, this.CustomTabTitle);
    }
  },
  /**
   * Updates settings from settings tab in admin panel.
   *
   * @param {boolean} bEnableUploadSizeLimit Indicates if upload size limit is enabled.
   * @param {number} iUploadSizeLimitMb Value of upload size limit in Mb.
   */
  updateAdmin: function updateAdmin(bEnableUploadSizeLimit, iUploadSizeLimitMb) {
    this.EnableUploadSizeLimit = bEnableUploadSizeLimit;
    this.UploadSizeLimitMb = iUploadSizeLimitMb;
  },
  updateAdminPersonal: function updateAdminPersonal(iUserSpaceLimitMb) {
    this.PersonalSpaceLimitMb = iUserSpaceLimitMb;
  },
  updateAdminCorporate: function updateAdminCorporate(iSpaceLimitMb) {
    this.CorporateSpaceLimitMb = iSpaceLimitMb;
  },
  getSortConfig: function getSortConfig(config) {
    return {
      Allow: Types.pBool(config === null || config === void 0 ? void 0 : config.Allow),
      DisplayOptions: (config === null || config === void 0 ? void 0 : config.DisplayOptions) || [],
      DefaultSortBy: Types.pEnum(Enums.FilesSortField[config === null || config === void 0 ? void 0 : config.DefaultSortBy], Enums.FilesSortField, Enums.FilesSortField.Filename),
      DefaultSortOrder: Types.pEnum(Enums.SortOrder[config === null || config === void 0 ? void 0 : config.DefaultSortOrder], Enums.SortOrder, Enums.SortOrder.Desc)
    };
  }
};

/***/ }),

/***/ "fnuI":
/*!*************************************************************!*\
  !*** ./modules/FilesWebclient/js/popups/CreateLinkPopup.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  Utils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Common.js */ "uQaC"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av"),
  Ajax = __webpack_require__(/*! modules/FilesWebclient/js/Ajax.js */ "5njy"),
  CFileModel = __webpack_require__(/*! modules/FilesWebclient/js/models/CFileModel.js */ "8ri2");

/**
 * @constructor
 */
function CCreateLinkPopup() {
  CAbstractPopup.call(this);
  this.fCallback = null;
  this.link = ko.observable('');
  this.linkPrev = ko.observable('');
  this.linkFocus = ko.observable(false);
  this.checkTimeout = null;
  this.urlChecked = ko.observable(false);
  this.saveCommand = Utils.createCommand(this, this.executeSave, function () {
    return this.urlChecked();
  });
  this.fileItem = ko.observable(null);
}
_.extendOwn(CCreateLinkPopup.prototype, CAbstractPopup.prototype);
CCreateLinkPopup.prototype.PopupTemplate = 'FilesWebclient_CreateLinkPopup';

/**
 * @param {Function} fCallback
 */
CCreateLinkPopup.prototype.onOpen = function (fCallback) {
  this.link('');
  this.linkFocus(true);
  this.fCallback = fCallback;
  this.checkTimer = setTimeout(_.bind(this.checkUrl, this), 2000);
};
CCreateLinkPopup.prototype.checkUrl = function () {
  clearTimeout(this.checkTimer);
  if (this.link() !== this.linkPrev()) {
    this.linkPrev(this.link());
    Ajax.send('CheckUrl', {
      'Url': this.link()
    }, this.onCheckUrlResponse, this);
  }
  this.checkTimer = setTimeout(_.bind(this.checkUrl, this), 1000);
};

/**
 * @param {Object} oResponse
 * @param {Object} oRequest
 */
CCreateLinkPopup.prototype.onCheckUrlResponse = function (oResponse, oRequest) {
  if (oResponse.Result) {
    var oData = CFileModel.prepareLinkData(oResponse.Result, this.link()),
      oFile = new CFileModel(oData);
    this.fileItem(oFile);
    this.urlChecked(true);
  }
};
CCreateLinkPopup.prototype.executeSave = function () {
  if (_.isFunction(this.fCallback)) {
    this.fCallback(this.fileItem());
    this.link('');
    this.linkPrev('');
    this.urlChecked(false);
  }
  clearTimeout(this.checkTimer);
  this.closePopup();
};
CCreateLinkPopup.prototype.cancelPopup = function () {
  this.link('');
  this.linkPrev('');
  this.urlChecked(false);
  clearTimeout(this.checkTimer);
  this.closePopup();
};
module.exports = new CCreateLinkPopup();

/***/ }),

/***/ "jkTn":
/*!**************************************************************!*\
  !*** ./modules/FilesWebclient/js/popups/SelectFilesPopup.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av"),
  CFilesView = __webpack_require__(/*! modules/FilesWebclient/js/views/CFilesView.js */ "v0iR");

/**
 * @constructor
 */
function CSelectFilesPopup() {
  CAbstractPopup.call(this);
  this.callbackHandler = function () {};
  this.filesView = new CFilesView(true);
  this.filesView.onSelectClickPopupBound = _.bind(this.selectFiles, this);
}
_.extendOwn(CSelectFilesPopup.prototype, CAbstractPopup.prototype);
CSelectFilesPopup.prototype.PopupTemplate = 'FilesWebclient_SelectFilesPopup';

/**
 * @param {Function} callbackHandler
 */
CSelectFilesPopup.prototype.onOpen = function (callbackHandler) {
  this.callbackHandler = _.isFunction(callbackHandler) ? callbackHandler : function () {};
  this.filesView.onShow();
};
CSelectFilesPopup.prototype.onBind = function () {
  this.filesView.onBind(this.$popupDom);
};
CSelectFilesPopup.prototype.selectFiles = function () {
  var selectedItems = this.filesView.selector.listCheckedAndSelected(),
    selectedFiles = selectedItems.filter(function (item) {
      return item.IS_FILE;
    });
  this.callbackHandler(selectedFiles);
  this.closePopup();
};
module.exports = new CSelectFilesPopup();

/***/ }),

/***/ "lfpz":
/*!******************************************************************!*\
  !*** ./modules/FilesWebclient/js/views/FilesSettingsFormView.js ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
  UrlUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Url.js */ "3cxN"),
  CAbstractSettingsFormView = ModulesManager.run('SettingsWebclient', 'getAbstractSettingsFormViewClass'),
  Settings = __webpack_require__(/*! modules/FilesWebclient/js/Settings.js */ "aSuo");

/**
 * @constructor
 */
function CFilesSettingsFormView() {
  CAbstractSettingsFormView.call(this, 'FilesWebclient');
  this.bShowFilesApps = Settings.ShowFilesApps;
  this.sAppPath = UrlUtils.getAppPath();
}
_.extendOwn(CFilesSettingsFormView.prototype, CAbstractSettingsFormView.prototype);
CFilesSettingsFormView.prototype.ViewTemplate = 'FilesWebclient_FilesSettingsFormView';
module.exports = new CFilesSettingsFormView();

/***/ }),

/***/ "lzoy":
/*!***********************************************************!*\
  !*** ./modules/FilesWebclient/js/models/CStorageModel.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9");

/**
 * @constructor
 * @param {Object} oData
 * @param {bool} oParent
 */

function CStorageModel(isCurrentStorageDroppable) {
  this.isCurrentStorageDroppable = isCurrentStorageDroppable;
  this.isExternal = false;
  this.type = '';
  this.displayName = '';
  this.hideInList = false;
  this.isDroppable = ko.observable(true);
  this.droppable = ko.computed(function () {
    return this.isDroppable() && this.isCurrentStorageDroppable();
  }, this);
  this.droppableDisabled = ko.computed(function () {
    return !this.droppable();
  }, this);
}
CStorageModel.prototype.parse = function (oData) {
  this.isExternal = Types.pBool(oData.IsExternal);
  this.type = Types.pString(oData.Type);
  this.displayName = Types.pString(oData.DisplayName);
  this.hideInList = Types.pBool(!!oData.HideInList);
  this.isDroppable(Types.pBool(oData.IsDroppable));
};
module.exports = CStorageModel;

/***/ }),

/***/ "sISN":
/*!********************************************************!*\
  !*** ./modules/FilesWebclient/js/popups/SharePopup.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  UrlUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Url.js */ "3cxN"),
  Api = __webpack_require__(/*! modules/CoreWebclient/js/Api.js */ "Z9uT"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av"),
  ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
  Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "PMEU"),
  Ajax = __webpack_require__(/*! modules/FilesWebclient/js/Ajax.js */ "5njy"),
  CFolderModel = __webpack_require__(/*! modules/FilesWebclient/js/models/CFolderModel.js */ "a2fk"),
  ShowHistoryPopup = ModulesManager.run('ActivityHistory', 'getShowHistoryPopup');

/**
 * @constructor
 */
function CSharePopup() {
  CAbstractPopup.call(this);
  this.item = null;
  this.pub = ko.observable('');
  this.pubFocus = ko.observable(false);
  this.bAllowShowHistory = !!ShowHistoryPopup;
}
_.extendOwn(CSharePopup.prototype, CAbstractPopup.prototype);
CSharePopup.prototype.PopupTemplate = 'FilesWebclient_SharePopup';

/**
 * @param {Object} oItem
 */
CSharePopup.prototype.onOpen = function (oItem) {
  this.item = oItem;
  this.pub('');
  Ajax.send('CreatePublicLink', {
    'Type': oItem.storageType(),
    'Path': oItem.path(),
    'Name': oItem.fileName(),
    'Size': oItem instanceof CFolderModel ? 0 : oItem.size(),
    'IsFolder': oItem instanceof CFolderModel
  }, this.onCreatePublicLinkResponse, this);
};

/**
 * @param {Object} response
 */
CSharePopup.prototype.onCreatePublicLinkResponse = function (response) {
  if (response.Result) {
    this.pub(UrlUtils.getAppPath() + response.Result);
    this.pubFocus(true);
    this.item.published(true);
  } else {
    Api.showErrorByCode(response, TextUtils.i18n('FILESWEBCLIENT/ERROR_CREATE_PUBLIC_LINK'));
  }
};
CSharePopup.prototype.onCancelSharingClick = function () {
  if (this.item) {
    Ajax.send('DeletePublicLink', {
      'Type': this.item.storageType(),
      'Path': this.item.path(),
      'Name': this.item.fileName()
    }, function (response) {
      if (!response.Result) {
        Api.showErrorByCode(response, TextUtils.i18n('FILESWEBCLIENT/ERROR_DELETE_PUBLIC_LINK'));
      } else {
        this.closePopup();
      }
    }, this);
    this.item.published(false);
  }
};
CSharePopup.prototype.showHistory = function () {
  if (this.bAllowShowHistory) {
    Popups.showPopup(ShowHistoryPopup, [TextUtils.i18n('FILESWEBCLIENT/HEADING_HISTORY_POPUP'), this.item]);
  }
};
module.exports = new CSharePopup();

/***/ }),

/***/ "v0iR":
/*!*******************************************************!*\
  !*** ./modules/FilesWebclient/js/views/CFilesView.js ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
var _ = __webpack_require__(/*! underscore */ "C3HO"),
  $ = __webpack_require__(/*! jquery */ "M4cL"),
  ko = __webpack_require__(/*! knockout */ "p09A");
var TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9"),
  Utils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Common.js */ "uQaC"),
  Api = __webpack_require__(/*! modules/CoreWebclient/js/Api.js */ "Z9uT"),
  App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
  CJua = __webpack_require__(/*! modules/CoreWebclient/js/CJua.js */ "hr1f"),
  CSelector = __webpack_require__(/*! modules/CoreWebclient/js/CSelector.js */ "DSoz"),
  ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
  Routing = __webpack_require__(/*! modules/CoreWebclient/js/Routing.js */ "ioSH"),
  Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh"),
  UserSettings = __webpack_require__(/*! modules/CoreWebclient/js/Settings.js */ "KIwC"),
  CAbstractScreenView = __webpack_require__(/*! modules/CoreWebclient/js/views/CAbstractScreenView.js */ "db2p"),
  Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "PMEU"),
  AlertPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/AlertPopup.js */ "Rjyw"),
  ConfirmPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/ConfirmPopup.js */ "MYiO");
var CreateFolderPopup = __webpack_require__(/*! modules/FilesWebclient/js/popups/CreateFolderPopup.js */ "WJcO"),
  CreateLinkPopup = __webpack_require__(/*! modules/FilesWebclient/js/popups/CreateLinkPopup.js */ "fnuI"),
  RenamePopup = __webpack_require__(/*! modules/FilesWebclient/js/popups/RenamePopup.js */ "2dqB"),
  SharePopup = __webpack_require__(/*! modules/FilesWebclient/js/popups/SharePopup.js */ "sISN"),
  LinksUtils = __webpack_require__(/*! modules/FilesWebclient/js/utils/Links.js */ "Ui65"),
  Ajax = __webpack_require__(/*! modules/FilesWebclient/js/Ajax.js */ "5njy"),
  Settings = __webpack_require__(/*! modules/FilesWebclient/js/Settings.js */ "aSuo"),
  CFileModel = __webpack_require__(/*! modules/FilesWebclient/js/models/CFileModel.js */ "8ri2"),
  CFolderModel = __webpack_require__(/*! modules/FilesWebclient/js/models/CFolderModel.js */ "a2fk"),
  CStorageModel = __webpack_require__(/*! modules/FilesWebclient/js/models/CStorageModel.js */ "lzoy");
var FilesSharePopup = ModulesManager.run('SharedFiles', 'getFilesSharePopup'),
  ComposeMessageWithAttachments = ModulesManager.run('MailWebclient', 'getComposeMessageWithAttachments');
var Enums = window.Enums;
/**
 * @constructor
 * @param {boolean=} bPopup = false
 * @param {boolean=} allowSelect = true
 */
function CFilesView() {
  var _this3 = this;
  var bPopup = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  var allowSelect = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  CAbstractScreenView.call(this, 'FilesWebclient');
  this.disableRoute = false; // can be changed outside

  this.browserTitle = ko.observable(TextUtils.i18n('FILESWEBCLIENT/HEADING_BROWSER_TAB'));
  this.bAllowSendEmails = _.isFunction(ComposeMessageWithAttachments);
  this.error = ko.observable(false);
  this.loaded = ko.observable(false);
  this.bPublic = App.isPublic();
  this.storages = ko.observableArray([]);
  this.folders = ko.observableArray();
  this.files = ko.observableArray();
  this.uploadingFiles = ko.observableArray();
  this.rootPath = ko.observable(this.bPublic ? Settings.PublicFolderName : TextUtils.i18n('FILESWEBCLIENT/LABEL_PERSONAL_STORAGE'));
  this.storageType = ko.observable(Enums.FileStorageType.Personal);
  this.currentStorage = ko.computed(function () {
    return this.getStorageByType(this.storageType());
  }, this);
  this.storageDroppable = ko.computed(function () {
    return this.currentStorage() ? this.currentStorage().droppable() : '';
  }, this);
  this.storageDisplayName = ko.computed(function () {
    return this.currentStorage() ? this.currentStorage().displayName : '';
  }, this);
  this.storageType.subscribe(function () {
    if (this.bPublic) {
      this.rootPath(Settings.PublicFolderName);
    } else {
      if (this.currentStorage()) {
        this.rootPath(this.currentStorage().displayName);
      }
      this.selector.listCheckedAndSelected(false);
    }
  }, this);
  this.createButtonsControllers = ko.observableArray([]);
  this.pathItems = ko.observableArray();
  this.currentPath = ko.observable('');
  this.isZipFolder = ko.computed(function () {
    var aPath = this.currentPath().split('$ZIP:');
    return Utils.getFileExtension(aPath[0]) === 'zip';
  }, this);
  this.dropPath = ko.observable('');
  ko.computed(function () {
    this.dropPath(this.currentPath());
  }, this);
  this.isCorporateStorage = ko.computed(function () {
    return this.storageType() === Enums.FileStorageType.Corporate;
  }, this);
  this.isSharedStorage = ko.computed(function () {
    return this.storageType() === Enums.FileStorageType.Shared;
  }, this);
  this.isEncryptedStorage = ko.computed(function () {
    return this.storageType() === Enums.FileStorageType.Encrypted;
  }, this);
  this.isExternalStorage = ko.computed(function () {
    return this.currentStorage() && this.currentStorage().isExternal;
  }, this);
  this.isTrashStorage = ko.computed(function () {
    return this.storageType() === Enums.FileStorageType.Trash;
  }, this);
  this.foldersCollection = ko.computed(function () {
    var _this = this;
    var aFolders = this.folders();
    aFolders.sort(function (left, right) {
      var sortValue;
      switch (_this.sortBy()) {
        case Enums.FilesSortField.Filename:
        case Enums.FilesSortField.Size:
          sortValue = left.fileName() === right.fileName() ? 0 : left.fileName() < right.fileName() ? -1 : 1;
          break;
        case Enums.FilesSortField.Modified:
          sortValue = left.iLastModified === right.iLastModified ? 0 : left.iLastModified < right.iLastModified ? -1 : 1;
          break;
      }
      if (_this.sortBy() !== Enums.FilesSortField.Size) {
        sortValue *= _this.sortOrder() === Enums.SortOrder.Desc ? -1 : 1;
      }
      return sortValue;
    });
    return aFolders;
  }, this);
  this.filesCollection = ko.computed(function () {
    var _this2 = this;
    var aFiles = _.union(this.files(), this.getUploadingFiles());
    aFiles.sort(function (left, right) {
      var sortValue;
      switch (_this2.sortBy()) {
        case Enums.FilesSortField.Filename:
          sortValue = left.fileName() === right.fileName() ? 0 : left.fileName() < right.fileName() ? -1 : 1;
          break;
        case Enums.FilesSortField.Size:
          sortValue = left.size() === right.size() ? 0 : left.size() < right.size() ? -1 : 1;
          break;
        case Enums.FilesSortField.Modified:
          sortValue = left.iLastModified === right.iLastModified ? 0 : left.iLastModified < right.iLastModified ? -1 : 1;
          break;
      }
      return sortValue * (_this2.sortOrder() === Enums.SortOrder.Desc ? -1 : 1);
      // return left.fileName() === right.fileName() ? 0 : (left.fileName() < right.fileName() ? -1 : 1);
    });

    // if (this.sortOrder() === Enums.SortOrder.Asc) {
    // 	aFolderList = aFolderList.reverse();
    // }

    return aFiles;
  }, this);
  this.collection = ko.computed(function () {
    return _.union(this.foldersCollection(), this.filesCollection());
  }, this);
  this.columnCount = ko.observable(1);
  this.selector = new CSelector(this.collection, _.bind(this.onItemSelect, this), _.bind(this.onItemDelete, this), _.bind(this.onItemDblClick, this), _.bind(this.onEnter, this), this.columnCount, true, true, true, false, allowSelect);
  this.firstSelectedFile = ko.computed(function () {
    return _.find(this.selector.listCheckedAndSelected(), function (oItem) {
      return oItem.IS_FILE;
    });
  }, this);
  this.selectedOwnItems = ko.computed(function () {
    return _.filter(this.selector.listCheckedAndSelected(), function (item) {
      return !item.sharedWithMe();
    });
  }, this);
  this.selectedHasShared = ko.computed(function () {
    return !!_.find(this.selector.listCheckedAndSelected(), function (oItem) {
      return oItem.sharedWithMe();
    });
  }, this);
  this.searchPattern = ko.observable('');
  this.newSearchPattern = ko.observable('');
  this.isSearchFocused = ko.observable(false);
  this.selectedFolders = ko.computed(function () {
    return _.filter(this.selector.listCheckedAndSelected(), function (oItem) {
      return oItem.IS_FOLDER;
    }, this);
  }, this);
  this.selectedFiles = ko.computed(function () {
    return _.filter(this.selector.listCheckedAndSelected(), function (oItem) {
      return oItem.IS_FILE;
    }, this);
  }, this);
  this.allSelectedFilesReady = ko.computed(function () {
    return _.every(this.selectedFiles(), function (oItem) {
      var bUploading = oItem.uploaded() === false,
        bDownloading = oItem.downloading() === true;
      return !bUploading && !bDownloading;
    });
  }, this);
  this.sharedParentFolder = ko.computed(function () {
    return _.find(this.pathItems(), function (oParentFolder) {
      return oParentFolder.sharedWithMe();
    });
  }, this);
  this.isDownloadAllowed = ko.computed(function () {
    var oFile = this.getFileIfOnlyOneSelected();
    return !!oFile && oFile.hasAction('download') && this.allSelectedFilesReady();
  }, this);
  this.downloadCommand = Utils.createCommand(this, this.executeDownload, this.isDownloadAllowed);
  this.isSendAllowed = ko.computed(function () {
    return !this.isZipFolder() && this.selectedFiles().length > 0 && this.allSelectedFilesReady();
  }, this);
  this.sendCommand = Utils.createCommand(this, this.executeSend, this.isSendAllowed);
  this.isRenameAllowed = ko.computed(function () {
    var oSharedParentFolder = this.sharedParentFolder(),
      aItems = this.selector.listCheckedAndSelected(),
      oSelectedItem = aItems.length === 1 ? aItems[0] : null;
    return !this.isZipFolder() && (!oSharedParentFolder || oSharedParentFolder.sharedWithMeAccessWrite()) && this.allSelectedFilesReady() && oSelectedItem;
  }, this);
  this.renameCommand = Utils.createCommand(this, this.executeRename, this.isRenameAllowed);
  this.bSortEnabled = Settings.Sorting && Settings.Sorting.Allow && Settings.Sorting.DisplayOptions && Settings.Sorting.DisplayOptions.length > 0;
  this.sortBy = ko.observable(Settings.Sorting.DefaultSortBy);
  this.sortOrder = ko.observable(Settings.Sorting.DefaultSortOrder);
  this.aSortList = [];
  if (this.bSortEnabled) {
    _.each(Enums.FilesSortField, function (iValue, sName) {
      if (Settings.Sorting.DisplayOptions.indexOf(sName) >= 0) {
        this.aSortList.push({
          sText: TextUtils.i18n('FILESWEBCLIENT/SORT_OPTION_' + sName.toUpperCase()),
          sSortBy: iValue
        });
      }
    }.bind(this));
  }
  this.itemsToDeleteCount = ko.computed(function () {
    var sharedParentFolder = this.sharedParentFolder();
    if (!!sharedParentFolder && sharedParentFolder.sharedWithMeAccessWrite()) {
      return this.selector.listCheckedAndSelected().length;
    }
    return this.selectedOwnItems().length;
  }, this);
  this.isDeleteAllowed = ko.computed(function () {
    return !this.isZipFolder() && this.itemsToDeleteCount() > 0 && this.allSelectedFilesReady();
  }, this);
  this.deleteCommand = Utils.createCommand(this, this.executeDelete, this.isDeleteAllowed);
  this.itemsToRestoreCount = ko.computed(function () {
    return this.selector.listCheckedAndSelected().length;
  }, this);
  this.isRestoreAllowed = ko.computed(function () {
    return this.isTrashStorage() && this.itemsToRestoreCount() > 0 && this.allSelectedFilesReady();
  }, this);
  this.restoreCommand = Utils.createCommand(this, this.executeRestore, this.isRestoreAllowed);
  this.needToCopyDraggedItems = ko.observable(false);
  this.isCurrentStorageDroppable = ko.computed(function () {
    return !this.sharedParentFolder() || this.needToCopyDraggedItems() || this.sharedParentFolder() && this.sharedParentFolder().sharedWithMeAccessWrite();
  }, this);
  this.isCutAllowed = ko.computed(function () {
    var oSharedParentFolder = this.sharedParentFolder(),
      aItems = this.selector.listCheckedAndSelected();
    return !this.isZipFolder() && (!oSharedParentFolder && !this.isSharedStorage() || !!oSharedParentFolder && oSharedParentFolder.sharedWithMeAccessWrite()) && this.allSelectedFilesReady() && aItems.length > 0;
  }, this);
  this.isCopyAllowed = ko.computed(function () {
    return this.allSelectedFilesReady() && this.selector.listCheckedAndSelected().length > 0;
  }, this);
  this.isDragAllowed = ko.computed(function () {
    return this.isCutAllowed() || this.needToCopyDraggedItems() && this.isCopyAllowed();
  }, this);

  // is used for share and simple public link
  this.isShareAllowed = ko.computed(function () {
    var items = this.selector.listCheckedAndSelected(),
      selectedItem = items.length === 1 ? items[0] : null,
      extendedProps = selectedItem && selectedItem.oExtendedProps;
    return !this.isZipFolder() && selectedItem && !selectedItem.bIsLink && (!this.sharedParentFolder() || this.sharedParentFolder().sharedWithMeAccessReshare() || selectedItem.sharedWithMeAccessReshare()) && this.allSelectedFilesReady() && (selectedItem.IS_FILE || !this.isEncryptedStorage()) && (!selectedItem.sharedWithMe() || selectedItem.sharedWithMeAccessReshare());
  }, this);
  this.createPublicLinkCommand = Utils.createCommand(this, this.createPublicLink, this.isShareAllowed);

  // Create in general for all kind of items
  this.isCreateAllowed = ko.computed(function () {
    var oSharedParentFolder = this.sharedParentFolder();
    return !this.isTrashStorage() && !this.isZipFolder() && (oSharedParentFolder && oSharedParentFolder.sharedWithMeAccessWrite() || !oSharedParentFolder && !this.isSharedStorage());
  }, this);
  this.createFolderCommand = Utils.createCommand(this, this.executeCreateFolder, this.isCreateAllowed);
  this.isCreateShortcutAllowed = ko.computed(function () {
    return this.isCreateAllowed() && !this.isExternalStorage() && !this.isEncryptedStorage();
  }, this);
  this.createShortcutCommand = Utils.createCommand(this, this.executeCreateShortcut, this.isCreateShortcutAllowed);
  this.checkstateCommand = Utils.createCommand(this, this.executeCheckstate);
  this.uploaderButton = ko.observable(null);
  this.uploaderArea = ko.observable(null);
  this.bDragActive = ko.observable(false);
  this.isNewItemsMenuOpened = ko.observable(false);
  this.bDragActiveComp = ko.computed(function () {
    var bDrag = this.bDragActive();
    return bDrag && this.searchPattern() === '';
  }, this);
  this.isDragAndDropSupported = ko.observable(false);
  this.isCreateAllowed.subscribe(function () {
    if (this.oJua) {
      this.oJua.setDragAndDropEnabledStatus(this.isCreateAllowed());
    }
  }, this);
  this.uploadError = ko.observable(false);
  this.quota = ko.observable(0);
  this.used = ko.observable(0);
  this.quotaDesc = ko.observable('');
  this.quotaProc = ko.observable(-1);
  this.bShowQuotaBarTextAsTooltip = UserSettings.ShowQuotaBarTextAsTooltip;
  this.aBottomLeftCornerLinks = Settings.BottomLeftCornerLinks;
  ko.computed(function () {
    if (!UserSettings.ShowQuotaBar) {
      return true;
    }
    var iQuota = this.quota(),
      iUsed = this.used(),
      iProc = 0 < iQuota ? Math.round(iUsed / iQuota * 100) : -1;
    iProc = 100 < iProc ? 100 : iProc;
    this.quotaProc(iProc);
    this.quotaDesc(-1 < iProc ? TextUtils.i18n('COREWEBCLIENT/INFO_QUOTA', {
      PROC: iProc,
      QUOTA: TextUtils.getFriendlySize(iQuota)
    }) : '');
    if (UserSettings.QuotaWarningPerc > 0 && iProc !== -1 && UserSettings.QuotaWarningPerc > 100 - iProc) {
      Screens.showError(TextUtils.i18n('COREWEBCLIENT/WARNING_QUOTA_ALMOST_REACHED'), true);
    }
  }, this);
  this.dragover = ko.observable(false);
  this.loading = ko.observable(false);
  this.loadedFiles = ko.observable(false);
  this.fileListInfoText = ko.computed(function () {
    var sInfoText = '';
    if (this.loading()) {
      sInfoText = TextUtils.i18n('COREWEBCLIENT/INFO_LOADING');
    } else if (this.loadedFiles()) {
      if (this.collection().length === 0) {
        if (this.searchPattern() !== '') {
          sInfoText = TextUtils.i18n('FILESWEBCLIENT/INFO_NOTHING_FOUND');
        } else if (this.isSharedStorage()) {
          sInfoText = TextUtils.i18n('FILESWEBCLIENT/INFO_SHARED_FOLDER_IS_EMPTY');
        } else if (this.currentPath() !== '' || this.bInPopup || this.bPublic) {
          sInfoText = TextUtils.i18n('FILESWEBCLIENT/INFO_FOLDER_IS_EMPTY');
        } else if (this.isDragAndDropSupported()) {
          sInfoText = TextUtils.i18n('FILESWEBCLIENT/INFO_DRAGNDROP_FILES_OR_CREATE_FOLDER');
        }
      }
    } else if (this.error()) {
      sInfoText = TextUtils.i18n('FILESWEBCLIENT/ERROR_FILES_NOT_RECEIVED');
    }
    return sInfoText;
  }, this);
  this.bInPopup = !!bPopup;
  this.timerId = null;
  this.itemsViewTemplate = ko.observable('FilesWebclient_ItemsView');
  App.subscribeEvent('Files::ShowList', _.bind(function (oParams) {
    if (this.shown() && oParams.Item) {
      this.routeFiles(oParams.Item.storageType(), oParams.Item.fullPath());
    }
  }, this));
  ConfirmPopup.opened.subscribe(_.bind(function () {
    if (this.shown()) {
      this.selector.useKeyboardKeys(true);
    }
  }, this));
  this.PublicLinksEnabled = Settings.PublicLinksEnabled;
  this.bAllowFavorites = Settings.AllowFavorites;
  this.currentFolderStatsString = ko.computed(function () {
    var iSizeSelected = 0,
      iSizeOveral = 0,
      sOUtput = '';
    this.files().forEach(function (oFile) {
      iSizeSelected += oFile.selected() || oFile.checked() ? oFile.size() : 0;
      iSizeOveral += oFile.size();
    });
    sOUtput = this.files().length === 0 && this.folders().length === 0 ? '' : TextUtils.i18n('FILESWEBCLIENT/CURRENT_FOLDER_STATS', {
      SIZE_OVERAL: TextUtils.getFriendlySize(iSizeOveral),
      FILES_OVERAL: this.files().length,
      FOLDERS_OVERAL: this.folders().length
    });
    sOUtput += this.selectedFiles().length === 0 ? '' : ' | ' + TextUtils.i18n('FILESWEBCLIENT/CURRENT_FOLDER_STATS_SELECTED_FILES', {
      SIZE_SELECTED: TextUtils.getFriendlySize(iSizeSelected),
      FILES_SELECTED: this.selectedFiles().length
    });
    sOUtput += this.selectedFolders().length === 0 ? '' : ' | ' + TextUtils.i18n('FILESWEBCLIENT/CURRENT_FOLDER_STATS_SELECTED_FOLDERS', {
      FOLDERS_SELECTED: this.selectedFolders().length
    });
    return sOUtput;
  }, this).extend({
    rateLimit: {
      timeout: 100,
      method: 'notifyWhenChangesStop'
    }
  });
  this.addToolbarButtons = ko.observableArray([]);
  this.storageControllers = ko.observableArray();
  this.controllers = ko.computed(function () {
    return [].concat(_toConsumableArray(_this3.addToolbarButtons()), _toConsumableArray(_this3.storageControllers()));
  });
  App.broadcastEvent('FilesWebclient::RegisterFilesController', function (controller, place) {
    _this3.registerController(controller, place);
  });
  App.broadcastEvent('FilesWebclient::ConstructView::after', {
    Name: this.ViewConstructorName,
    View: this
  });
}
_.extendOwn(CFilesView.prototype, CAbstractScreenView.prototype);
CFilesView.prototype.ViewTemplate = App.isPublic() ? 'FilesWebclient_PublicFilesView' : 'FilesWebclient_FilesView';
CFilesView.prototype.ViewConstructorName = 'CFilesView';
CFilesView.prototype.registerCreateButtonsController = function (oBigButtonView) {
  this.createButtonsControllers.push(oBigButtonView);
};

/**
 * @param {object} $popupDom
 */
CFilesView.prototype.onBind = function ($popupDom) {
  var _this4 = this;
  var $dom = this.$viewDom || $popupDom;
  this.selector.initOnApplyBindings('.items_sub_list .item', '.items_sub_list .selected.item', '.items_sub_list .item .custom_checkbox', $('.panel.files .items_list', $dom), $('.panel.files .items_list .files_scroll.scroll-inner', $dom));
  $('.files_scroll').on('click', function (event) {
    var _event$target;
    var targetClassName = ((_event$target = event.target) === null || _event$target === void 0 ? void 0 : _event$target.className) || '';
    if (targetClassName.includes('files_scroll') || targetClassName.includes('items_list') || targetClassName.includes('items_sub_list')) {
      _this4.selector.listCheckedAndSelected(false);
    }
  });
  this.initUploader();
  this.hotKeysBind();
};
CFilesView.prototype.hotKeysBind = function () {
  $(document).on('keydown', _.bind(function (ev) {
    if (this.shown() && ev && ev.keyCode === Enums.Key.s && this.selector.useKeyboardKeys() && !Utils.isTextFieldFocused()) {
      ev.preventDefault();
      this.isSearchFocused(true);
    }
  }, this));
};

/**
 * Initializes file uploader.
 */
CFilesView.prototype.initUploader = function () {
  var self = this;
  if (!this.bPublic && this.uploaderButton() && this.uploaderArea()) {
    this.oJua = new CJua({
      action: '?/Api/',
      name: 'jua-uploader',
      queueSize: 2,
      clickElement: this.uploaderButton(),
      hiddenElementsPosition: UserSettings.IsRTL ? 'right' : 'left',
      dragAndDropElement: this.uploaderArea(),
      disableAjaxUpload: false,
      disableFolderDragAndDrop: false,
      disableDragAndDrop: false,
      hidden: _.extendOwn({
        Module: Settings.ServerModuleName,
        Method: 'UploadFile',
        Parameters: function Parameters(oFile) {
          return JSON.stringify({
            Type: self.storageType(),
            SubPath: oFile && oFile.Folder || '',
            Path: self.dropPath(),
            Overwrite: false
          });
        }
      }, App.getCommonRequestParameters())
    });
    this.oJua.on('onProgress', _.bind(this.onFileUploadProgress, this)).on('onSelect', _.bind(this.onFileUploadSelect, this)).on('onStart', _.bind(this.onFileUploadStart, this)).on('onDrop', _.bind(this.onDrop, this)).on('onEmptyFolderDrop', this.onEmptyFolderDrop.bind(this)).on('onComplete', _.bind(this.onFileUploadComplete, this)).on('onBodyDragEnter', _.bind(this.bDragActive, this, true)).on('onBodyDragLeave', _.bind(this.bDragActive, this, false)).on('onCancel', _.bind(this.onCancelUpload, this)).on('onDialog', _.bind(function () {
      setTimeout(_.bind(this.isNewItemsMenuOpened, this, false), 10);
    }, this, false));
    this.isDragAndDropSupported(this.oJua.isDragAndDropSupported());
  }
};

/**
 * Checks if the file can be uploaded
 *
 * @param {Object} oFileData
 */
CFilesView.prototype.isFileCanBeUploaded = function (oFileData) {
  if (Settings.EnableUploadSizeLimit && oFileData.Size / (1024 * 1024) > Settings.UploadSizeLimitMb) {
    Popups.showPopup(AlertPopup, [TextUtils.i18n('FILESWEBCLIENT/ERROR_SIZE_LIMIT', {
      FILENAME: oFileData.FileName,
      SIZE: Settings.UploadSizeLimitMb
    })]);
    return false;
  }
  if (this.storageType() === Enums.FileStorageType.Personal && Types.isPositiveNumber(this.quota())) {
    if (this.quota() > 0 && this.used() + oFileData.Size > this.quota()) {
      Popups.showPopup(AlertPopup, [TextUtils.i18n('COREWEBCLIENT/ERROR_CANT_UPLOAD_FILE_QUOTA')]);
      return false;
    }
  }
  return true;
};

/**
 * Creates new attachment for upload.
 *
 * @param {string} sFileUid
 * @param {Object} fileData
 */
CFilesView.prototype.onFileUploadSelect = function (sFileUid, fileData) {
  var _this5 = this;
  if (!this.isFileCanBeUploaded(fileData)) {
    return false;
  }
  if (this.searchPattern() === '') {
    var getFileByName = function getFileByName(fileName) {
        if (_this5.getFileByName(fileName)) {
          return true;
        } else {
          return !!_.find(_this5.getUploadingFiles(), function (oItem) {
            return oItem.fileName() === fileName;
          });
        }
      },
      storage = this.storageType(),
      path = this.currentPath(),
      correctedData = CFileModel.prepareUploadFileData(fileData, path, storage, getFileByName);
    var file = this.getUploadFileByUid(sFileUid);
    if (file) {
      file.fileName(correctedData.Name);
      file.fullPath(correctedData.FullPath);
    } else {
      file = new CFileModel(correctedData, this);
    }
    file.onUploadSelect(sFileUid, fileData, true);
    this.uploadingFiles.push(file);
    this.onFileFromSubfolderUploadSelect(fileData);
    return true;
  }
  return false;
};

/**
 * If selected for upload file is from subfolder increase uploading files count for this folder.
 * @param {Object} oFileData
 */
CFilesView.prototype.onFileFromSubfolderUploadSelect = function (oFileData) {
  if (Types.isNonEmptyString(oFileData.Folder)) {
    var aPath = _.compact(oFileData.Folder.split('/')),
      sFolderName = aPath[0],
      oFolder = _.find(this.folders(), function (oTmpFolder) {
        return oTmpFolder.fileName() === sFolderName;
      });
    if (sFolderName && !oFolder) {
      oFolder = new CFolderModel(this);
      oFolder.parse({
        Name: sFolderName
      });
      this.folders.push(oFolder);
    }
    oFolder.increaseUploadingFiles();
  }
};

/**
 * Finds attachment by uid. Calls it's function to start upload.
 *
 * @param {string} sFileUid
 */
CFilesView.prototype.onFileUploadStart = function (sFileUid) {
  var oFile = this.getUploadFileByUid(sFileUid);
  if (oFile) {
    oFile.onUploadStart();
  }
};

/**
 * Finds attachment by uid. Calls it's function to progress upload.
 *
 * @param {string} sFileUid
 * @param {number} iUploadedSize
 * @param {number} iTotalSize
 */
CFilesView.prototype.onFileUploadProgress = function (sFileUid, iUploadedSize, iTotalSize) {
  if (this.searchPattern() === '') {
    var oFile = this.getUploadFileByUid(sFileUid);
    if (oFile) {
      oFile.onUploadProgress(iUploadedSize, iTotalSize);
    }
  }
};

/**
 * Finds attachment by uid. Calls it's function to complete upload.
 *
 * @param {string} sFileUid File identifier.
 * @param {boolean} bResponseReceived Indicates if upload was successfull.
 * @param {Object} oResult Response from the server.
 */
CFilesView.prototype.onFileUploadComplete = function (sFileUid, bResponseReceived, oResult) {
  if (this.searchPattern() === '') {
    var oFile = this.getUploadFileByUid(sFileUid),
      bRequestFiles = false;
    if (oFile) {
      oFile.onUploadComplete(sFileUid, bResponseReceived, oResult);
      this.onFileWithSubfolderUploadComplete(oFile);
      this.deleteUploadFileByUid(sFileUid);
      if (oFile.uploadError()) {
        this.uploadError(true);
        if (oResult && oResult.ErrorCode === Enums.Errors.CanNotUploadFileQuota) {
          Popups.showPopup(AlertPopup, [TextUtils.i18n('COREWEBCLIENT/ERROR_CANT_UPLOAD_FILE_QUOTA')]);
          bRequestFiles = true;
        } else if (oResult && oResult.ErrorCode === Enums.Errors.FileAlreadyExists) {
          bRequestFiles = true;
          Screens.showError(TextUtils.i18n('COREWEBCLIENT/ERROR_FILE_ALREADY_EXISTS'));
        } else if (oResult && oResult.ErrorCode === Enums.Errors.FileNotFound) {
          bRequestFiles = true;
          Screens.showError(TextUtils.i18n('COREWEBCLIENT/ERROR_FILE_NOT_FOUND'));
        } else {
          Screens.showError(oFile.statusText());
        }
      } else {
        if (oFile.path() === this.currentPath() && oFile.storageType() === this.storageType()) {
          this.files.push(oFile);
        }
        if (this.uploadingFiles().length === 0) {
          Screens.showReport(TextUtils.i18n('COREWEBCLIENT/REPORT_UPLOAD_COMPLETE'));
        }
      }
      if (this.uploadingFiles().length === 0) {
        bRequestFiles = true;
      }
    } else {
      bRequestFiles = true;
    }
    if (bRequestFiles) {
      this.routeFiles(this.storageType(), this.currentPath(), this.searchPattern(), true);
    }
  }
};

/**
 * If uploaded file is from subfolder increase uploaded files count for this folder.
 * @param {Object} oFile
 */
CFilesView.prototype.onFileWithSubfolderUploadComplete = function (oFile) {
  if (oFile.sUploadSubFolder) {
    var aPath = _.compact(oFile.sUploadSubFolder.split('/')),
      sFolderName = aPath[0],
      oFolder = _.find(this.folders(), function (oTmpFolder) {
        return oTmpFolder.fileName() === sFolderName;
      });
    if (oFolder) {
      oFolder.increaseUploadedFiles();
    }
  }
};
CFilesView.prototype.onEmptyFolderDrop = function (folderData) {
  if (folderData && folderData.fullPath) {
    var folderName = folderData.fullPath.charAt(0) === '/' ? folderData.fullPath.substr(1) : folderData.fullPath;
    Ajax.send('CreateFolder', {
      Type: this.storageType(),
      Path: this.currentPath(),
      FolderName: folderData.fullPath
    }, this.onCreateFolderResponse, this);
  }
};

/**
 * @param {Object} oFile
 * @param {Object} oEvent
 */
CFilesView.prototype.onDrop = function (oFile, oEvent) {
  if (this.bPublic) {
    return;
  }
  if (oEvent && oEvent.target && this.searchPattern() === '') {
    var oFolder = ko.dataFor(oEvent.target);
    if (oFolder && oFolder instanceof CFolderModel) {
      this.dropPath(oFolder.fullPath());
    }
  } else {
    Screens.showReport(TextUtils.i18n('FILESWEBCLIENT/INFO_CANNOT_UPLOAD_SEARCH_RESULT'));
  }
};

/**
 * @param {Object} oFolder
 * @param {Object} oEvent
 * @param {Object} oUi
 */
CFilesView.prototype.filesDrop = function (oFolder, oEvent, oUi) {
  if (this.bPublic || !this.isDragAllowed()) {
    return;
  }
  if (oEvent) {
    var aChecked = this.selector.listCheckedAndSelected(),
      sMethod = this.needToCopyDraggedItems() ? 'Copy' : 'Move';
    if (this.moveItems(sMethod, oFolder, aChecked)) {
      Utils.uiDropHelperAnim(oEvent, oUi);
    }
  }
};

/**
 * @param {string} sMethod
 * @param {object} oFolder
 * @param {array} aChecked
 * @returns {boolean}
 */
CFilesView.prototype.moveItems = function (sMethod, oFolder, aChecked) {
  if (this.bPublic) {
    return false;
  }
  var sFromPath = '',
    sFromStorageType = '',
    bFromAllSame = true,
    bFolderIntoItself = false,
    sToPath = oFolder instanceof CFolderModel ? oFolder.fullPath() : '',
    aItems = [],
    sStorageType = oFolder ? oFolder instanceof CFolderModel ? oFolder.storageType() : oFolder.type : this.storageType(),
    oToStorage = this.getStorageByType(sStorageType),
    oFromStorage = this.currentStorage(),
    bSameStorage = oToStorage.type === oFromStorage.type,
    iUsed = this.used(),
    iQuota = this.quota(),
    bAllowMove = true;
  if (bSameStorage || !bSameStorage && !oToStorage.isExternal && !oFromStorage.isExternal && Enums.FileStorageType.Shared !== oToStorage.type) {
    if (oToStorage.type === Enums.FileStorageType.Personal && oFromStorage.type !== Enums.FileStorageType.Personal) {
      bAllowMove = _.every(aChecked, function (oItem) {
        if (oItem instanceof CFileModel) {
          if (iQuota > 0 && iUsed + oItem.size() > iQuota) {
            return false;
          }
          iUsed = iUsed + oItem.size();
        }
        return true;
      });
      if (!bAllowMove) {
        Popups.showPopup(AlertPopup, [TextUtils.i18n('FILESWEBCLIENT/ERROR_CANT_MOVE_FILES_QUOTA_PLURAL', {}, '', aChecked.length)]);
        return false;
      }
    }
    _.each(aChecked, _.bind(function (oItem) {
      if (sFromPath !== '' && sFromPath !== oItem.path() || sFromStorageType !== '' && sFromStorageType !== oItem.storageType()) {
        bFromAllSame = false;
      }
      sFromPath = oItem.path();
      sFromStorageType = oItem.storageType();
      bFolderIntoItself = oItem instanceof CFolderModel && sToPath === sFromPath + '/' + oItem.id();
      if (!bFolderIntoItself) {
        if (sMethod === 'Move') {
          if (oItem instanceof CFileModel) {
            this.deleteFileByName(oItem.id());
          } else {
            this.deleteFolderByName(oItem.fileName());
          }
        }
        aItems.push({
          FromType: sFromStorageType,
          FromPath: sFromPath,
          Name: oItem.id(),
          IsFolder: oItem instanceof CFolderModel
        });
      }
    }, this));
    if (aItems.length > 0) {
      if (!bFromAllSame) {
        sFromStorageType = '';
        sFromPath = '';
      }
      Ajax.send(sMethod, {
        FromType: sFromStorageType,
        ToType: sStorageType,
        FromPath: sFromPath,
        ToPath: sToPath,
        Files: aItems
      }, this.onMoveResponse, this);
      if (oFolder instanceof CFolderModel) {
        oFolder.recivedAnim(true);
      }
      return true;
    }
  }
  return false;
};

/**
 * @param {Object} oResponse
 * @param {Object} oRequest
 */
CFilesView.prototype.onMoveResponse = function (oResponse, oRequest) {
  if (!oResponse.Result) {
    if (oResponse.ErrorCode === Enums.Errors.CanNotUploadFileQuota) {
      Popups.showPopup(AlertPopup, [TextUtils.i18n('FILESWEBCLIENT/ERROR_CANT_MOVE_FILES_QUOTA_PLURAL', {}, '', oRequest.Parameters.Files.length)]);
    } else {
      Api.showErrorByCode(oResponse, TextUtils.i18n('FILESWEBCLIENT/ERROR_FILES_MOVE_PLURAL', {}, '', oRequest.Parameters.Files.length));
    }
    this.routeFiles(this.storageType(), this.currentPath(), this.searchPattern());
  } else {
    if (this.storageType() === oRequest.Parameters.ToType && this.currentPath() === oRequest.Parameters.ToPath) {
      this.routeFiles(this.storageType(), this.currentPath(), this.searchPattern());
    } else {
      this.getQuota();
    }
  }
};

/**
 * @param {Object} oDraggedItem
 * @param {boolean} ctrlOrCmdUsed
 */
CFilesView.prototype.dragAndDropHelper = function (oDraggedItem, ctrlOrCmdUsed) {
  if (!oDraggedItem || !oDraggedItem.allowDrag()) {
    return $('<span></span>');
  }
  oDraggedItem.checked(true);
  this.needToCopyDraggedItems(ctrlOrCmdUsed);
  if (!this.isDragAllowed()) {
    return $('<span></span>');
  }
  var oHelper = Utils.draggableItems(),
    aItems = this.selector.listCheckedAndSelected(),
    oCounts = _.countBy(aItems, function (oItem) {
      return oItem.IS_FILE ? 'file' : 'folder';
    }),
    sPlusPrefix = ctrlOrCmdUsed ? '+ ' : '',
    sText = '';
  if (!oCounts.file) {
    sText = TextUtils.i18n('FILESWEBCLIENT/LABEL_DRAG_FOLDERS_PLURAL', {
      COUNT: sPlusPrefix + oCounts.folder
    }, null, oCounts.folder);
  } else if (!oCounts.folder) {
    sText = TextUtils.i18n('FILESWEBCLIENT/LABEL_DRAG_FILES_PLURAL', {
      COUNT: sPlusPrefix + oCounts.file
    }, null, oCounts.file);
  } else {
    sText = TextUtils.i18n('FILESWEBCLIENT/LABEL_DRAG_ITEMS_PLURAL', {
      COUNT: sPlusPrefix + aItems.length
    }, null, aItems.length);
  }
  $('.count-text', oHelper).text(sText);
  return oHelper;
};
CFilesView.prototype.onItemDelete = function () {
  if (this.isDeleteAllowed()) {
    this.executeDelete();
  }
};
CFilesView.prototype.onItemSelect = function (oItem) {
  if (App.isMobile() && oItem instanceof CFolderModel) {
    this.onItemDblClick(oItem);
  }
};

/**
 * @param {CFileModel|CFolderModel} oItem
 */
CFilesView.prototype.onEnter = function (oItem) {
  this.onItemDblClick(oItem);
};

/**
 * Executes on item double click.
 * @param {CFileModel|CFolderModel} oItem
 */
CFilesView.prototype.onItemDblClick = function (oItem) {
  if (oItem) {
    var sMainAction = oItem.getMainAction();
    switch (sMainAction) {
      case 'view':
        if (oItem instanceof CFileModel) {
          if (this.onSelectClickPopupBound) {
            this.onSelectClickPopupBound();
          } else {
            oItem.executeAction(sMainAction);
          }
        }
        break;
      case 'list':
        if (!(oItem instanceof CFolderModel) || !oItem.isIncomplete()) {
          this.routeFiles(oItem.storageType(), oItem.fullPath());
        }
        break;
    }
  }
};

/**
 * @param {Object} oResponse
 * @param {Object} oRequest
 */
CFilesView.prototype.onGetFilesResponse = function (oResponse, oRequest) {
  var oResult = oResponse.Result,
    oParameters = oRequest.Parameters;
  this.bNotLoading = false;
  if ((oParameters.Type === this.storageType() || oParameters.Hash === Settings.PublicHash) && oParameters.Path === this.currentPath()) {
    if (oResult) {
      var aNewFolderList = [],
        aNewFileList = [];
      _.each(oResult.Items, function (oData) {
        if (oData.IsFolder) {
          var oFolder = new CFolderModel(this);
          oFolder.parse(oData);
          this.checkIfFolderUploading(oFolder);
          aNewFolderList.push(oFolder);
        } else {
          var oFile = new CFileModel(oData, this);
          if (oFile.oExtendedProps && oFile.oExtendedProps.Loading) {
            // if file still loading - show warning in status
            oFile.uploadError(true);
            oFile.statusText(TextUtils.i18n('COREWEBCLIENT/LABEL_FILE_LOADING'));
          }
          oFile.index(aNewFileList.length);
          aNewFileList.push(oFile);
        }
      }, this);

      // save status of files that are being loaded
      _.each(this.files(), function (oTmpFile, iFileIndex, aFiles) {
        if (oTmpFile.downloading()) {
          var iNewIndex = _.findIndex(aNewFileList, function (oNewTmpFile) {
            return oTmpFile.fileName() === oNewTmpFile.fileName();
          });
          if (iNewIndex !== -1) {
            aFiles[iFileIndex].index(aNewFileList[iNewIndex].index());
            aNewFileList[iNewIndex] = aFiles[iFileIndex];
          }
        }
      });
      this.folders(aNewFolderList);
      this.files(aNewFileList);
      this.newSearchPattern(oParameters.Pattern || '');
      this.searchPattern(oParameters.Pattern || '');
      this.loadedFiles(true);
      clearTimeout(this.timerId);
      this.parseQuota(oResult.Quota);
      if (_.isArray(oResult.Path)) {
        this.pathItems.removeAll();
        _.each(oResult.Path.reverse(), _.bind(function (oPathItem) {
          var oFolder = new CFolderModel(this);
          oFolder.parse(oPathItem);
          this.pathItems.push(oFolder);
        }, this));
      }
      this.loading(false);

      //If the current path does not contain information about access, we obtain such information from the response, if possible
      if (oResult.Access && this.pathItems().length > 0) {
        var iLastIndex = this.pathItems().length - 1,
          lastItem = this.pathItems()[iLastIndex];
        if (!lastItem.oExtendedProps || !lastItem.oExtendedProps.SharedWithMeAccess) {
          this.pathItems()[iLastIndex].updateExtendedProps({
            SharedWithMeAccess: oResult.Access
          });
          this.pathItems.valueHasMutated(); // for triggering sharedParentFolder computing
        }
      }
    } else {
      if (oResponse.ErrorCode !== Enums.Errors.NotDisplayedError) {
        this.loading(false);
        this.error(true);
        Api.showErrorByCode(oResponse, TextUtils.i18n('FILESWEBCLIENT/ERROR_FILES_NOT_RECEIVED'));
      }
    }
  }
};

/**
 * Checks if folder has uploding files and marks it as uploading.
 * @param {Object} oFolder
 */
CFilesView.prototype.checkIfFolderUploading = function (oFolder) {
  _.each(this.uploadingFiles(), function (oFile) {
    if (oFile.sUploadSubFolder) {
      var aPath = _.compact(oFile.sUploadSubFolder.split('/')),
        sFolderName = aPath[0];
      if (oFolder.fileName() === sFolderName) {
        oFolder.increaseUploadingFiles();
      }
    }
  });
};

/**
 * Runs after getting quota information from the server. Fill quota values.
 *
 * @param {Object} oQuota
 */
CFilesView.prototype.parseQuota = function (oQuota) {
  if (oQuota) {
    this.quota(Types.pInt(oQuota.Limit));
    this.used(Types.pInt(oQuota.Used));
  }
};

/**
 * @param {Object} oResponse
 * @param {Object} oRequest
 */
CFilesView.prototype.onDeleteResponse = function (oResponse, oRequest) {
  if (oResponse.Result) {
    this.expungeFileItems();
    this.getQuota();
  } else {
    Api.showErrorByCode(oResponse);
    this.routeFiles(this.storageType(), this.currentPath(), this.searchPattern());
  }
};
CFilesView.prototype.executeRename = function () {
  var oItem = _.first(this.selector.listCheckedAndSelected()),
    bSeparateExtension = Settings.EditFileNameWithoutExtension && oItem instanceof CFileModel,
    sName = bSeparateExtension ? Utils.getFileNameWithoutExtension(oItem.fileName()) : oItem.fileName(),
    sExtension = bSeparateExtension ? Utils.getFileExtension(oItem.fileName()) : '';
  if (!this.bPublic && oItem) {
    Popups.showPopup(RenamePopup, [sName, _.bind(this.renameItem, this, sExtension)]);
  }
};

/**
 * @param {string} sExtension
 * @param {string} sNamePart
 * @returns {string}
 */
CFilesView.prototype.renameItem = function (sExtension, sNamePart) {
  var sName = sExtension === '' ? sNamePart : sNamePart + '.' + sExtension,
    oItem = _.first(this.selector.listCheckedAndSelected());
  if (!Utils.validateFileOrFolderName(sName)) {
    return oItem instanceof CFolderModel ? TextUtils.i18n('FILESWEBCLIENT/ERROR_INVALID_FOLDER_NAME') : TextUtils.i18n('FILESWEBCLIENT/ERROR_INVALID_FILE_NAME');
  } else {
    Ajax.send('Rename', {
      Type: oItem.storageType(),
      Path: oItem.path(),
      Name: oItem.id() || oItem.fileName(),
      NewName: sName,
      IsLink: oItem.bIsLink,
      IsFolder: !oItem.IS_FILE
    }, this.onRenameResponse, this);
  }
  return '';
};
CFilesView.prototype.executeSort = function (sValue) {
  var sCurrentSort = this.sortBy();
  this.sortBy(sValue);
  if (sCurrentSort === sValue) {
    this.sortOrder(this.sortOrder() === Enums.SortOrder.Asc ? Enums.SortOrder.Desc : Enums.SortOrder.Asc); // Asc: 0, Desc: 1
  } else {
    this.sortOrder(Settings.Sorting.DefaultSortOrder);
  }
};
CFilesView.prototype.getFileIfOnlyOneSelected = function () {
  var aItems = this.selector.listCheckedAndSelected();
  return 1 === aItems.length && aItems[0] instanceof CFileModel ? aItems[0] : null;
};
CFilesView.prototype.executeDownload = function () {
  var oFile = this.getFileIfOnlyOneSelected();
  if (oFile) {
    oFile.executeAction('download');
  }
};
CFilesView.prototype.createPublicLink = function () {
  var oItem = _.first(this.selector.listCheckedAndSelected());
  if (!this.bPublic && oItem) {
    Popups.showPopup(SharePopup, [oItem]);
  }
};
CFilesView.prototype.executeSend = function () {
  var aFilesData = _.map(this.selectedFiles(), function (oItem) {
    return {
      Storage: oItem.storageType(),
      Path: oItem.path(),
      Name: oItem.id() || oItem.fileName()
    };
  });
  if (this.bAllowSendEmails && aFilesData.length > 0) {
    Ajax.send('SaveFilesAsTempFiles', {
      Files: aFilesData
    }, function (oResponse) {
      if (oResponse.Result) {
        ComposeMessageWithAttachments(oResponse.Result);
      }
    }, this);
  }
};
CFilesView.prototype.onFavoriteClick = function (oItem) {
  if (oItem) {
    var originalState = oItem.favorite();
    oItem.favorite(!oItem.favorite());
    Ajax.send(originalState ? 'RemoveFromFavorites' : 'AddToFavorites', {
      Items: [{
        Type: 'personal',
        Path: oItem.path(),
        Name: oItem.fileName()
      }]
    }, function (oResponse) {
      if (originalState) {
        oItem.favorite(!oResponse.Result);
      } else {
        oItem.favorite(!!oResponse.Result);
      }
      if (!oResponse.Result) {
        Screens.showError(TextUtils.i18n('FILESWEBCLIENT/ERROR_FAVORITE_NOT_SET'));
      }
    }, this);
  }
};

/**
 * @param {Object} oItem
 */
CFilesView.prototype.onShareIconClick = function (oItem) {
  if (oItem) {
    Popups.showPopup(SharePopup, [oItem]);
  }
};

/**
 * @param {Object} oItem
 */
CFilesView.prototype.onSecureIconClick = function (oItem) {
  if (oItem && _.isFunction(oItem.onSecureIconClick)) {
    oItem.onSecureIconClick(oItem);
  }
};

/**
 * @param {Object} oItem
 */
CFilesView.prototype.onFileShareIconClick = function (oItem) {
  if (FilesSharePopup && oItem) {
    Popups.showPopup(FilesSharePopup, [oItem, this.expungeFileItems.bind(this)]);
  }
};

/**
 * @param {Object} oResponse
 * @param {Object} oRequest
 */
CFilesView.prototype.onRenameResponse = function (oResponse, oRequest) {
  if (!oResponse.Result) {
    Api.showErrorByCode(oResponse, TextUtils.i18n('FILESWEBCLIENT/ERROR_FILE_RENAME'));
  }
  this.routeFiles(this.storageType(), this.currentPath(), this.searchPattern(), true);
};
CFilesView.prototype.refresh = function () {
  this.routeFiles(this.storageType(), this.currentPath(), this.searchPattern(), true);
};
CFilesView.prototype.executeDelete = function () {
  var sharedParentFolder = this.sharedParentFolder(),
    allowDeleteSharedItems = !!sharedParentFolder && sharedParentFolder.sharedWithMeAccessWrite(),
    items = this.selector.listCheckedAndSelected() || [],
    itemsToDelete = allowDeleteSharedItems ? items : this.selectedOwnItems(),
    itemsToDeleteCount = itemsToDelete.length;
  if (!this.bPublic && itemsToDeleteCount > 0) {
    var storagesThatSupportsTrash = [Enums.FileStorageType.Personal, Enums.FileStorageType.Shared, Enums.FileStorageType.Corporate, Enums.FileStorageType.Encrypted];
    if (Settings.AllowTrash && storagesThatSupportsTrash.indexOf(this.storageType()) !== -1) {
      var hasSharedWithOthers = !!_.find(itemsToDelete, function (item) {
        return item.sharedWithOthers();
      });
      if (hasSharedWithOthers) {
        this.selector.useKeyboardKeys(false);
        Popups.showPopup(ConfirmPopup, [TextUtils.i18n('FILESWEBCLIENT/CONFIRM_SOME_ITEMS_SHARED_WITH_OTHERS'), _.bind(this.deleteItems, this, itemsToDelete), '', TextUtils.i18n('COREWEBCLIENT/ACTION_DELETE')]);
      } else {
        this.deleteItems(itemsToDelete, true);
      }
    } else {
      var askAboutSharedItems = items.length !== itemsToDeleteCount,
        hasFolder = !!_.find(itemsToDelete, function (item) {
          return !item.IS_FILE;
        }),
        hasFile = !!_.find(itemsToDelete, function (item) {
          return item.IS_FILE;
        }),
        confirmText = '';
      if (askAboutSharedItems) {
        confirmText = TextUtils.i18n('FILESWEBCLIENT/CONFIRM_NOT_ALL_ITEMS_OWN');
      } else if (hasFolder && hasFile) {
        confirmText = TextUtils.i18n('FILESWEBCLIENT/CONFIRM_DELETE_ITEMS_PLURAL', {
          COUNT: itemsToDeleteCount
        }, null, itemsToDeleteCount);
      } else if (hasFolder) {
        confirmText = TextUtils.i18n('FILESWEBCLIENT/CONFIRM_DELETE_FOLDERS_PLURAL', {
          COUNT: itemsToDeleteCount
        }, null, itemsToDeleteCount);
      } else {
        confirmText = TextUtils.i18n('FILESWEBCLIENT/CONFIRM_DELETE_FILES_PLURAL', {
          COUNT: itemsToDeleteCount
        }, null, itemsToDeleteCount);
      }
      this.selector.useKeyboardKeys(false);
      Popups.showPopup(ConfirmPopup, [confirmText, _.bind(this.deleteItems, this, itemsToDelete), '', TextUtils.i18n('COREWEBCLIENT/ACTION_DELETE')]);
    }
  }
};
CFilesView.prototype.executeRestore = function () {
  var itemsToRestore = this.selector.listCheckedAndSelected() || [],
    itemsToRestoreCount = itemsToRestore.length,
    confirmText = TextUtils.i18n('FILESWEBCLIENT/CONFIRM_RESTORE_ITEMS_PLURAL', {
      COUNT: itemsToRestoreCount
    }, null, itemsToRestoreCount),
    originalPaths = [],
    originalPathsLength = 0;
  _.each(itemsToRestore, function (fileItem) {
    if (fileItem && fileItem.oExtendedProps && fileItem.oExtendedProps.TrashOriginalPath) {
      originalPaths.push(TextUtils.i18n('FILESWEBCLIENT/LABEL_PERSONAL_STORAGE') + fileItem.oExtendedProps.TrashOriginalPath);
    }
  });
  originalPathsLength = originalPaths.length;
  originalPaths = _.first(originalPaths, 3);
  if (originalPathsLength > 0) {
    confirmText = confirmText + '<br><br>' + originalPaths.join('<br>');
    if (originalPathsLength > 3) {
      confirmText = confirmText + '<br>...';
    }
  }
  this.selector.useKeyboardKeys(false);
  Popups.showPopup(ConfirmPopup, [confirmText, _.bind(this.restoreItems, this, itemsToRestore), '', TextUtils.i18n('FILESWEBCLIENT/ACTION_RESTORE')]);
};
CFilesView.prototype.onShow = function () {
  this.loaded(true);
  if (!this.bPublic) {
    this.requestStorages();
  }
  this.selector.useKeyboardKeys(true);
  if (this.oJua) {
    this.oJua.setDragAndDropEnabledStatus(true);
  }
  this.controllers().forEach(function (controller) {
    if (typeof controller.onShow === 'function') {
      controller.onShow();
    }
  });
};
CFilesView.prototype.onHide = function () {
  this.selector.useKeyboardKeys(false);
  if (this.oJua) {
    this.oJua.setDragAndDropEnabledStatus(false);
  }
  this.controllers().forEach(function (controller) {
    if (typeof controller.onHide === 'function') {
      controller.onHide();
    }
  });
};
CFilesView.prototype.getQuota = function () {
  Ajax.send('GetQuota', {
    Type: this.storageType()
  }, function (oResponse) {
    if (oResponse.Result) {
      this.parseQuota(oResponse.Result);
    }
  }, this);
};

/**
 * @param {string} sStorageType
 */
CFilesView.prototype.getStorageByType = function (sStorageType) {
  return _.find(this.storages(), function (oStorage) {
    return oStorage.type === sStorageType;
  });
};

/**
 * Requests storages from the server.
 */
CFilesView.prototype.requestStorages = function () {
  Ajax.send('GetStorages', null, this.onGetStoragesResponse, this);
};

/**
 * Parses server response to a request of storages.
 * @param {Object} oResponse
 * @param {Object} oRequest
 */
CFilesView.prototype.onGetStoragesResponse = function (oResponse, oRequest) {
  var oResult = oResponse.Result;
  if (oResult) {
    _.each(oResult, function (oStorage) {
      if (oStorage.Type && !this.getStorageByType(oStorage.Type)) {
        var oStorageModel = new CStorageModel(this.isCurrentStorageDroppable);
        oStorageModel.parse(oStorage);
        this.storages.push(oStorageModel);
      }
    }, this);
    this.expungeExternalStorages(_.map(oResult, function (oStorage) {
      return oStorage.Type;
    }, this));
  }
  if (!this.currentStorage()) {
    this.storageType(Enums.FileStorageType.Personal);
    this.pathItems.removeAll();
  }
  if (this.bInPopup) {
    this.routeFiles(this.storageType(), this.currentPath(), this.searchPattern(), true);
  }
};

/**
 * Clears file/folder list and displays loading message.
 */
CFilesView.prototype.clearAndShowLoading = function () {
  this.folders([]);
  this.files([]);
  this.loading(true);
};
CFilesView.prototype.currentGetFiles = function () {
  var iPathItemsCount = this.pathItems().length,
    oParameters = {
      Type: this.storageType(),
      Path: this.currentPath(),
      Pattern: this.searchPattern(),
      PathRequired: this.currentPath() !== '' && iPathItemsCount === 0
    };
  Ajax.send('GetFiles', oParameters, this.onGetFilesResponse, this);
};

/**
 * Sets routing hash.
 * @param {string} sStorage Storage type.
 * @param {string=} sFullPath = '' Path to files/folders to display.
 * @param {string=} sSearch = '' Search string.
 * @param {boolean=} bNotLoading = false Indicates if loading message should be displayed with delay.
 */
CFilesView.prototype.routeFiles = function (sStorage, sFullPath, sSearch, bNotLoading) {
  if (this.disableRoute) {
    return;
  }
  var bSame = false;
  if (this.bPublic) {
    bSame = Routing.setHash(LinksUtils.getFiles('', sFullPath, ''));
    if (bSame) {
      this.clearAndShowLoading();
      Ajax.send('GetPublicFiles', {
        Hash: Settings.PublicHash,
        Path: this.currentPath()
      }, this.onGetFilesResponse, this);
    }
  } else {
    this.bNotLoading = bNotLoading;
    if (this.bInPopup) {
      this.onUserRoute(LinksUtils.getParsedParams(sStorage, sFullPath, sSearch));
    } else {
      bSame = Routing.setHash(LinksUtils.getFiles(sStorage, sFullPath, sSearch));
      if (bSame) {
        this.clearAndShowLoading();
        this.currentGetFiles();
      }
    }
  }
};

/**
 * Adds path item to path item list.
 * @param {string} sStorage Storage type.
 * @param {string} sPath Path of item.
 * @param {string} sName Name of item.
 */
CFilesView.prototype.addPathItems = function (sStorage, sPath, sName) {
  var oFolder = new CFolderModel(this);
  oFolder.storageType(sStorage);
  oFolder.fileName(sName);
  oFolder.path(sPath);
  oFolder.fullPath(sPath);
  this.pathItems.unshift(oFolder);
};

/**
 * Requests files after routing parse.
 * @param {array} aParams
 */
CFilesView.prototype.onRoute = function (aParams) {
  var oParams = LinksUtils.parseFiles(aParams);
  if (this.bPublic) {
    this.onPublicRoute(oParams);
  } else {
    this.onUserRoute(oParams);
  }
  this.controllers().forEach(function (controller) {
    if (typeof controller.onRoute === 'function') {
      controller.onRoute(oParams);
    }
  });
};

/**
 * Requests user files after routing parse.
 * @param {object} oParams
 */
CFilesView.prototype.onUserRoute = function (oParams) {
  var bStorageFound = this.storages().length === 0 || !!_.find(this.storages(), function (oStorage) {
      return oStorage.type === oParams.Storage;
    }),
    sStorage = bStorageFound ? oParams.Storage : this.storages().length > 0 ? this.storages()[0].type : '',
    sPath = oParams.Path;
  this.error(false);
  this.storageType(sStorage);
  this.currentPath(sPath);
  this.searchPattern(Types.pString(oParams.Search));
  this.loadedFiles(false);
  this.populatePathItems(oParams);
  if (this.bNotLoading && (this.files().length > 0 || this.folders().length > 0)) {
    this.timerId = setTimeout(_.bind(function () {
      if (!this.loadedFiles() && !this.error()) {
        this.clearAndShowLoading();
      }
    }, this), 3000);
  } else {
    this.clearAndShowLoading();
  }
  this.currentGetFiles();
};
CFilesView.prototype.populatePathItems = function (oParams) {
  var sPath = this.currentPath(),
    aPath = oParams.PathParts.reverse(),
    oFolder = _.find(this.folders(), function (oFld) {
      return oFld.fullPath() === sPath;
    }),
    iPathItemIndex = _.findIndex(this.pathItems(), function (oItem) {
      return oItem.fullPath() === sPath;
    });
  if (iPathItemIndex !== -1) {
    this.pathItems(this.pathItems().slice(0, iPathItemIndex + 1));
  } else if (oFolder) {
    this.pathItems.push(oFolder);
  } else if (this.storageType() !== 'google' || sPath === '') {
    this.pathItems.removeAll();
    _.each(aPath, _.bind(function (sPathItem) {
      var iItemPos = sPath.lastIndexOf(sPathItem);
      this.addPathItems(this.storageType(), sPath, sPathItem);
      sPath = sPath.substr(0, iItemPos);
    }, this));
    var oParameters = {
      Type: this.storageType(),
      Path: this.currentPath()
    };
    Ajax.send('GetAccessInfoForPath', oParameters, function (response) {
      if (response && response.Result) {
        _.each(this.pathItems(), function (pathItem) {
          var itemPath = pathItem.fullPath();
          if (itemPath.substr(itemPath.length - 1, 1) === '/') {
            itemPath = itemPath.substr(0, itemPath.length - 1);
          }
          if (response.Result[itemPath]) {
            pathItem.updateExtendedProps({
              SharedWithMeAccess: response.Result[itemPath]
            });
          }
        });
        this.pathItems.valueHasMutated(); // for triggering sharedParentFolder computing
      }
    }, this);
  }
};

/**
 * Requests public files after routing parse.
 * @param {object} oParams
 */
CFilesView.prototype.onPublicRoute = function (oParams) {
  var sPath = oParams.Path,
    aPath = oParams.PathParts.reverse(),
    sFirstPathItem = '';
  this.currentPath(sPath);
  this.pathItems.removeAll();
  _.each(aPath, _.bind(function (sPathItem) {
    var iItemPos = sPath.lastIndexOf(sPathItem);
    this.addPathItems(oParams.Storage, sPath, sPathItem);
    sPath = sPath.substr(0, iItemPos);
    sFirstPathItem = sPathItem;
  }, this));
  if (sFirstPathItem !== this.rootPath()) {
    this.addPathItems(oParams.Storage, '', this.rootPath());
  }
  this.clearAndShowLoading();
  Ajax.send('GetPublicFiles', {
    Hash: Settings.PublicHash,
    Path: this.currentPath()
  }, this.onGetFilesResponse, this);
};

/**
 * @param {Array} aChecked
 * @param {boolean} bOkAnswer
 * @param {string} methodName
 */
CFilesView.prototype.deleteItems = function (aChecked, bOkAnswer) {
  var methodName = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'Delete';
  var sStorageType = this.storageType(),
    sPath = this.currentPath();
  if (bOkAnswer && 0 < aChecked.length) {
    var aItems = _.compact(_.map(aChecked, function (oItem) {
      if (oItem.id() !== '') {
        oItem.deleted(true);
        sStorageType = oItem.storageType();
        return {
          Path: oItem.path(),
          Name: oItem.id(),
          IsFolder: !oItem.IS_FILE
        };
      }
      return null;
    }));
    if (aItems.length) {
      Ajax.send(methodName, {
        Type: sStorageType,
        Path: sPath,
        Items: aItems
      }, this.onDeleteResponse, this);
    }
  }
};

/**
 * @param {Array} aChecked
 * @param {boolean} bOkAnswer
 */
CFilesView.prototype.restoreItems = function (aChecked, bOkAnswer) {
  if (bOkAnswer && 0 < aChecked.length) {
    var aItems = _.compact(_.map(aChecked, function (oItem) {
      if (oItem.id() !== '') {
        oItem.deleted(true);
        return oItem.id();
      }
      return null;
    }));
    if (aItems.length) {
      Ajax.send('Restore', {
        Items: aItems
      }, this.onDeleteResponse, this);
    }
  }
};

/**
 * @param {string} sName
 *
 * @return {?}
 */
CFilesView.prototype.getFileByName = function (sName) {
  return _.find(this.files(), function (oItem) {
    return oItem.fileName() === sName;
  });
};

/**
 * @param {object} oFile
 */
CFilesView.prototype.addFileToCurrentFolder = function (oFile) {
  if (this.searchPattern() === '') {
    this.files.push(oFile);
  }
};

/**
 * @param {string} sName
 */
CFilesView.prototype.deleteFileByName = function (sName) {
  this.files(_.filter(this.files(), function (oItem) {
    return oItem.id() !== sName;
  }));
};

/**
 * @param {string} sName
 */
CFilesView.prototype.deleteFolderByName = function (sName) {
  this.folders(_.filter(this.folders(), function (oItem) {
    return oItem.fileName() !== sName;
  }));
};
CFilesView.prototype.expungeFileItems = function () {
  this.folders(_.filter(this.folders(), function (oFolder) {
    return !oFolder.deleted();
  }, this));
  this.files(_.filter(this.files(), function (oFile) {
    return !oFile.deleted();
  }, this));
};

/**
 * @param {array} aStorageTypes
 */
CFilesView.prototype.expungeExternalStorages = function (aStorageTypes) {
  this.storages(_.filter(this.storages(), function (oStorage) {
    return !oStorage.isExternal || _.include(aStorageTypes, oStorage.type);
  }, this));
};

/**
 * @param {string} sFileUid
 *
 * @return {?}
 */
CFilesView.prototype.getUploadFileByUid = function (sFileUid) {
  return _.find(this.uploadingFiles(), function (oItem) {
    return oItem.uploadUid() === sFileUid;
  });
};

/**
 * @param {string} sFileUid
 */
CFilesView.prototype.deleteUploadFileByUid = function (sFileUid) {
  this.uploadingFiles(_.filter(this.uploadingFiles(), function (oItem) {
    return oItem.uploadUid() !== sFileUid;
  }));
};

/**
 * @return {Array}
 */
CFilesView.prototype.getUploadingFiles = function () {
  return _.filter(this.uploadingFiles(), _.bind(function (oItem) {
    return oItem.path() === this.currentPath() && oItem.storageType() === this.storageType();
  }, this));
};

/**
 * @param {string} sFileUid
 */
CFilesView.prototype.onCancelUpload = function (sFileUid) {
  this.deleteUploadFileByUid(sFileUid);
  if (this.oJua) {
    this.oJua.cancel(sFileUid);
  }
};

/**
 * @param {Object} oResponse
 * @param {Object} oRequest
 */
CFilesView.prototype.onCreateFolderResponse = function (oResponse, oRequest) {
  if (!oResponse.Result) {
    Api.showErrorByCode(oResponse);
  }
  this.routeFiles(this.storageType(), this.currentPath(), this.searchPattern(), true);
};

/**
 * @param {string} sFolderName
 */
CFilesView.prototype.createFolder = function (sFolderName) {
  sFolderName = $.trim(sFolderName);
  if (!Utils.validateFileOrFolderName(sFolderName)) {
    return TextUtils.i18n('FILESWEBCLIENT/ERROR_INVALID_FOLDER_NAME');
  } else {
    Ajax.send('CreateFolder', {
      Type: this.storageType(),
      Path: this.currentPath(),
      FolderName: sFolderName
    }, this.onCreateFolderResponse, this);
  }
  return '';
};
CFilesView.prototype.executeCreateFolder = function () {
  Popups.showPopup(CreateFolderPopup, [_.bind(this.createFolder, this)]);
};

/**
 * @param {Object} oResponse
 * @param {Object} oRequest
 */
CFilesView.prototype.onCreateLinkResponse = function (oResponse, oRequest) {
  this.routeFiles(this.storageType(), this.currentPath(), this.searchPattern(), true);
};

/**
 * @param {Object} oFileItem
 */
CFilesView.prototype.createLink = function (oFileItem) {
  Ajax.send('CreateLink', {
    Type: this.storageType(),
    Path: this.currentPath(),
    Link: oFileItem.sLinkUrl,
    Name: oFileItem.fileName()
  }, this.onCreateLinkResponse, this);
};
CFilesView.prototype.executeCreateShortcut = function () {
  var fCallBack = _.bind(this.createLink, this);
  Popups.showPopup(CreateLinkPopup, [fCallBack]);
};
CFilesView.prototype.onSearch = function () {
  this.routeFiles(this.storageType(), this.currentPath(), this.newSearchPattern());
};
CFilesView.prototype.clearSearch = function () {
  this.routeFiles(this.storageType(), this.currentPath());
};
CFilesView.prototype.executeCheckstate = function () {
  this.routeFiles(this.storageType(), this.currentPath(), this.searchPattern());
};
CFilesView.prototype.getCurrentFolder = function () {
  var oFolder = new CFolderModel(this);
  oFolder.fullPath(this.currentPath());
  oFolder.storageType(this.storageType());
  return oFolder;
};
CFilesView.prototype.registerToolbarButtons = function (toolbarButtonsControllers) {
  var _this6 = this;
  if (Types.isNonEmptyArray(toolbarButtonsControllers)) {
    toolbarButtonsControllers.forEach(function (toolbarButtonsController) {
      _this6.registerController(toolbarButtonsController, 'ToolbarButton');
    });
  }
};

/**
 * @param {Object} controller
 * @param {string} placeName
 */
CFilesView.prototype.registerController = function (controller, placeName) {
  var isRegistered = false;
  switch (placeName) {
    case 'Storage':
      this.storageControllers.push(controller);
      isRegistered = true;
      break;
    case 'ToolbarButton':
      this.addToolbarButtons.push(controller);
      isRegistered = true;
      break;
  }
  if (isRegistered && typeof controller.useFilesViewData === 'function') {
    controller.useFilesViewData(this);
  }
};
CFilesView.prototype.onFileRemove = function (sFileUploadUid, oFile) {
  var
  /**
  * Send request for deleting file with sFileName
  * @param {String} sFileUploadUid
  * @param {String} sFileName
  */
  fOnUploadCancelCallback = _.bind(function (sFileUploadUid, sFileName) {
    var oParameters = {
      Type: this.storageType(),
      Path: this.currentPath(),
      Items: [{
        Path: this.currentPath(),
        Name: sFileName,
        IsFolder: false
      }]
    };
    Ajax.send('Delete', oParameters, function (oResponse) {
      if (!oResponse.Result) {
        Api.showErrorByCode(oResponse);
      }
      this.currentGetFiles();
    }, this);
    this.onCancelUpload(sFileUploadUid);
  }, this);
  if (oFile.downloading()) {
    App.broadcastEvent('CFilesView::FileDownloadCancel', {
      oFile: oFile
    });
  } else if (!oFile.uploaded() && sFileUploadUid) {
    var bEventCaught = App.broadcastEvent('CFilesView::FileUploadCancel', {
      sFileUploadUid: sFileUploadUid,
      sFileUploadName: oFile.fileName(),
      fOnUploadCancelCallback: fOnUploadCancelCallback
    });
    if (!bEventCaught) {
      fOnUploadCancelCallback(sFileUploadUid, oFile.fileName());
    }
  }
};
module.exports = CFilesView;

/***/ }),

/***/ "vV+s":
/*!*******************************************************************!*\
  !*** ./modules/FilesWebclient/js/views/MobileSyncSettingsView.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var ko = __webpack_require__(/*! knockout */ "p09A"),
  App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
  UserSettings = __webpack_require__(/*! modules/CoreWebclient/js/Settings.js */ "KIwC");

/**
 * @constructor
 */
function CMobileSyncSettingsView() {
  this.davServer = ko.observable('');
  this.credentialsHintText = App.mobileCredentialsHintText;
  this.bDemo = UserSettings.IsDemo;
}
CMobileSyncSettingsView.prototype.ViewTemplate = 'FilesWebclient_MobileSyncSettingsView';

/**
 * @param {Object} oDav
 */
CMobileSyncSettingsView.prototype.populate = function (oDav) {
  this.davServer(oDav.Server);
};
module.exports = new CMobileSyncSettingsView();

/***/ })

}]);