"use strict";
(self["webpackChunkafterlogic_aurora_platform"] = self["webpackChunkafterlogic_aurora_platform"] || []).push([[28],{

/***/ "PtJJ":
/*!**************************************************************!*\
  !*** ./modules/StandardRegisterFormWebclient/js/Settings.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9");
module.exports = {
  ServerModuleName: 'StandardRegisterFormWebclient',
  HashModuleName: 'register',
  CustomLogoUrl: '',
  InfoText: '',
  BottomInfoHtmlText: '',
  /**
   * Initializes settings from AppData object sections.
   * 
   * @param {Object} oAppData Object contained modules settings.
   */
  init: function init(oAppData) {
    var oAppDataSection = oAppData['StandardRegisterFormWebclient'];
    if (!_.isEmpty(oAppDataSection)) {
      this.ServerModuleName = Types.pString(oAppDataSection.ServerModuleName, this.ServerModuleName);
      this.HashModuleName = Types.pString(oAppDataSection.HashModuleName, this.HashModuleName);
      this.CustomLogoUrl = Types.pString(oAppDataSection.CustomLogoUrl, this.CustomLogoUrl);
      this.InfoText = Types.pString(oAppDataSection.InfoText, this.InfoText);
      this.BottomInfoHtmlText = Types.pString(oAppDataSection.BottomInfoHtmlText, this.BottomInfoHtmlText);
    }
  }
};

/***/ }),

/***/ "fIJW":
/*!*************************************************************!*\
  !*** ./modules/StandardRegisterFormWebclient/js/manager.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



module.exports = function (oAppData) {
  var App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
    Settings = __webpack_require__(/*! modules/StandardRegisterFormWebclient/js/Settings.js */ "PtJJ"),
    bAnonimUser = App.getUserRole() === Enums.UserRole.Anonymous;
  Settings.init(oAppData);
  if (!App.isPublic() && bAnonimUser) {
    if (App.isMobile()) {
      return {
        /**
         * Returns register view screen as is.
         */
        getRegisterScreenView: function getRegisterScreenView() {
          return __webpack_require__(/*! modules/StandardRegisterFormWebclient/js/views/RegisterView.js */ "jy+g");
        },
        getHashModuleName: function getHashModuleName() {
          return Settings.HashModuleName;
        }
      };
    } else {
      return {
        /**
         * Returns login view screen.
         */
        getScreens: function getScreens() {
          var oScreens = {};
          oScreens[Settings.HashModuleName] = function () {
            return __webpack_require__(/*! modules/StandardRegisterFormWebclient/js/views/RegisterView.js */ "jy+g");
          };
          return oScreens;
        }
      };
    }
  }
  return null;
};

/***/ }),

/***/ "jy+g":
/*!************************************************************************!*\
  !*** ./modules/StandardRegisterFormWebclient/js/views/RegisterView.js ***!
  \************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  $ = __webpack_require__(/*! jquery */ "M4cL"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  UrlUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Url.js */ "3cxN"),
  Utils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Common.js */ "uQaC"),
  Api = __webpack_require__(/*! modules/CoreWebclient/js/Api.js */ "Z9uT"),
  App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
  Browser = __webpack_require__(/*! modules/CoreWebclient/js/Browser.js */ "/Odb"),
  Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh"),
  CAbstractScreenView = __webpack_require__(/*! modules/CoreWebclient/js/views/CAbstractScreenView.js */ "db2p"),
  Ajax = __webpack_require__(/*! modules/CoreWebclient/js/Ajax.js */ "8QQh"),
  Settings = __webpack_require__(/*! modules/StandardRegisterFormWebclient/js/Settings.js */ "PtJJ"),
  $html = $('html');

/**
 * @constructor
 */
function CRegisterView() {
  CAbstractScreenView.call(this, 'StandardRegisterFormWebclient');
  this.sCustomLogoUrl = Settings.CustomLogoUrl;
  this.sInfoText = Settings.InfoText;
  this.sBottomInfoHtmlText = Settings.BottomInfoHtmlText;
  this.login = ko.observable('');
  this.enableLoginEdit = ko.observable(true);
  this.password = ko.observable('');
  this.confirmPassword = ko.observable('');
  this.loginFocus = ko.observable(false);
  this.passwordFocus = ko.observable(false);
  this.confirmPasswordFocus = ko.observable(false);
  this.loading = ko.observable(false);
  this.canTryRegister = ko.computed(function () {
    return !this.loading();
  }, this);
  this.registerButtonText = ko.computed(function () {
    return this.loading() ? TextUtils.i18n('COREWEBCLIENT/ACTION_REGISTER_IN_PROGRESS') : TextUtils.i18n('COREWEBCLIENT/ACTION_REGISTER');
  }, this);
  this.registerCommand = Utils.createCommand(this, this.register, this.canTryRegister);
  this.shake = ko.observable(false).extend({
    'autoResetToFalse': 800
  });
  this.welcomeText = ko.observable('');
  App.subscribeEvent('ShowWelcomeRegisterText', _.bind(function (oParams) {
    this.welcomeText(oParams.WelcomeText);
    this.login(oParams.UserName);
    this.enableLoginEdit(false);
  }, this));
  this.beforeButtonsControllers = ko.observableArray([]);
  App.broadcastEvent('AnonymousUserForm::PopulateBeforeButtonsControllers', {
    ModuleName: 'StandardRegisterFormWebclient',
    RegisterBeforeButtonsController: this.registerBeforeButtonsController.bind(this)
  });
  App.broadcastEvent('StandardRegisterFormWebclient::ConstructView::after', {
    'Name': this.ViewConstructorName,
    'View': this
  });
}
_.extendOwn(CRegisterView.prototype, CAbstractScreenView.prototype);
CRegisterView.prototype.ViewTemplate = 'StandardRegisterFormWebclient_RegisterView';
CRegisterView.prototype.ViewConstructorName = 'CRegisterView';
CRegisterView.prototype.onBind = function () {
  $html.addClass('non-adjustable-valign');
};

/**
 * Focuses login input after view showing.
 */
CRegisterView.prototype.onShow = function () {
  _.delay(_.bind(function () {
    if (this.login() === '') {
      this.loginFocus(true);
    }
  }, this), 1);
};

/**
 * 
 * @param {string} sLogin
 * @param {string} sPassword
 * @param {string} sConfirmPassword
 * @returns {Boolean}
 */
CRegisterView.prototype.validateForm = function (sLogin, sPassword, sConfirmPassword) {
  if (sLogin === '') {
    this.loginFocus(true);
    this.shake(true);
    return false;
  }
  if (sPassword === '') {
    this.passwordFocus(true);
    this.shake(true);
    return false;
  }
  if (sPassword !== '' && sPassword !== sConfirmPassword) {
    this.confirmPasswordFocus(true);
    this.shake(true);
    Screens.showError(TextUtils.i18n('COREWEBCLIENT/ERROR_PASSWORDS_DO_NOT_MATCH'));
    return false;
  }
  return true;
};

/**
 * Checks login input value and sends register request to server.
 */
CRegisterView.prototype.register = function () {
  if (!this.loading()) {
    var login = $.trim(this.login()),
      password = $.trim(this.password()),
      confirmPassword = $.trim(this.confirmPassword());
    if (this.validateForm(login, password, confirmPassword)) {
      var parameters = {
        'Login': login,
        'Password': password
      };
      var eventParameters = {
        Module: 'StandardRegisterFormWebclient',
        Parameters: parameters
      };
      App.broadcastEvent('AnonymousUserForm::PopulateFormSubmitParameters', eventParameters);
      this.loading(true);
      Ajax.send('StandardRegisterFormWebclient', 'Register', parameters, this.onRegisterResponse, this);
    }
  }
};

/**
 * Receives data from the server. Shows error and shakes form if server has returned false-result.
 * Otherwise clears search-string if it don't contain "reset-pass", "invite-auth" and "oauth" parameters and reloads page.
 * 
 * @param {Object} oResponse Data obtained from the server.
 * @param {Object} oRequest Data has been transferred to the server.
 */
CRegisterView.prototype.onRegisterResponse = function (oResponse, oRequest) {
  if (false === oResponse.Result) {
    this.loading(false);
    this.shake(true);
    Api.showErrorByCode(oResponse, TextUtils.i18n('COREWEBCLIENT/ERROR_REGISTRATION_FAILED'));
  } else {
    if (window.location.search !== '' && UrlUtils.getRequestParam('reset-pass') === null && UrlUtils.getRequestParam('invite-auth') === null && UrlUtils.getRequestParam('oauth') === null) {
      UrlUtils.clearAndReloadLocation(Browser.ie8AndBelow, true);
    } else {
      UrlUtils.clearAndReloadLocation(Browser.ie8AndBelow, false);
    }
  }
};

/**
 * @param {Object} oComponent
 */
CRegisterView.prototype.registerBeforeButtonsController = function (oComponent) {
  this.beforeButtonsControllers.push(oComponent);
};
module.exports = new CRegisterView();

/***/ })

}]);