
/* =======================================================================
 * vCard Library for .NET
 * Copyright (c) 2007-2009 David Pinch; http://wwww.thoughtproject.com
 * See LICENSE.TXT for licensing information.
 * ======================================================================= */

using System;

namespace vCards
{

    /// <summary>
    ///     Identifies different vCard formats.
    /// </summary>
    public enum vCardFormat
    {

        /// <summary>
        ///     Standard text format.
        /// </summary>
        Text,

        /// <summary>
        ///     Jabber XML format (not implemented yet).
        /// </summary>
        JabberXml,


        /// <summary>
        ///     RDF format (not implemented yet).
        /// </summary>
        Rdf,


        /// <summary>
        ///     hCard microformat (not implemented yet).
        /// </summary>
        hCard

    }

}