<?php

$sP7ProductPath = "";
$sFileSuccess = "../data/migrate-collected.txt";

$sP7ApiPath = $sP7ProductPath . '/libraries/afterlogic/api.php';
set_time_limit(0);
if (!file_exists($sP7ApiPath))
{
	exit("Wrong path for import");
}

require_once $sP7ApiPath;
require_once "../system/autoload.php";
\Aurora\System\Api::Init(true);

if ((defined('STDIN'))||(empty($_SERVER['REMOTE_ADDR']) and !isset($_SERVER['HTTP_USER_AGENT']) and count($_SERVER['argv']) > 0))
	define ("CEOL",PHP_EOL);
else 
	define ("CEOL","<br />");
	
$oP7Settings = \CApi::GetSettings();
$oP7PDO = \CApi::GetPDO();
if (!$oP7PDO instanceof PDO) {
	exit("Error during connection to p7 DB.");
}
$oP8PDO = \Aurora\System\Api::GetPDO();
if (!$oP8PDO instanceof \PDO) {
	exit("Error during connection to p8 DB.");
}
$oP8Settings = \Aurora\System\Api::GetSettings();

$oP7ApiUsersManager = \CApi::Manager('users');
$oP7ApiContactsManager = \CApi::Manager('contacts');

$oP8ContactsDecorator = \Aurora\System\Api::GetModuleDecorator('Contacts');
$oP8CoreDecorator = \Aurora\System\Api::GetModuleDecorator('Core');

$sGetUserLIstQuery = "SELECT DISTINCT `email` FROM `" . \CApi::GetSettings()->GetConf('Common/DBPrefix') . "awm_accounts`
				WHERE `def_acct`=1
				ORDER BY `email`";
$stmt = \CApi::GetPDO()->prepare($sGetUserLIstQuery);
$stmt->execute();
$aUsers = $stmt->fetchAll(PDO::FETCH_COLUMN, 0);

if (file_exists($sFileSuccess)) {
	$sEmail = trim(file_get_contents($sFileSuccess));
	if (strlen($sEmail)>2) {
		$iLastItem = array_search($sEmail, $aUsers);
		if ($iLastItem!==false) {
			$aUsers=array_slice($aUsers,1+$iLastItem);
		}
	}
}

foreach ($aUsers as $sP7UserEmail) {
	echo "User: ".$sP7UserEmail.CEOL;
	$oP7Account = $oP7ApiUsersManager->getAccountByEmail($sP7UserEmail);
	if (!$oP7Account instanceof \CAccount)
	{
		echo "User not found in p7 DB".CEOL.CEOL;
		continue;
	}
	$iP7UserId = $oP7Account->IdUser;
	$oP8User = $oP8CoreDecorator->GetUserByPublicId($sP7UserEmail);
	
	if (!$oP8User instanceof \Aurora\Modules\Core\Classes\User)
	{
		echo "User not found in p8 DB".CEOL.CEOL;
		continue;
	}

	$aCollected = $oP7ApiContactsManager->getSuggestItems($oP7Account, '', 99999);

	$iContactsDone = 0;
	$aContact = [];
	foreach ($aCollected as $oContact) {
		if ($oContact->Auto == 1) {
			$aContact["PersonalEmail"] = $oContact->Email;
			$aContact["FullName"] = $oContact->Name;
			$aContact["Auto"] = true;
			$oP8ContactsDecorator->CreateContact($aContact,$oP8User->EntityId);
			unset($aContact);
			$iContactsDone++;
		}
	}
	echo "Contacts added: ".$iContactsDone.CEOL.CEOL;
	file_put_contents($sFileSuccess, $sP7UserEmail);
}