"use strict";
(self["webpackChunkaurora_webmail_pro"] = self["webpackChunkaurora_webmail_pro"] || []).push([[58],{

/***/ "22M0":
/*!****************************************************************!*\
  !*** ./modules/OpenPgpWebclient/js/popups/GenerateKeyPopup.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  $ = __webpack_require__(/*! jquery */ "M4cL"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
  AddressUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Address.js */ "rBrp"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
  Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av"),
  ErrorsUtils = __webpack_require__(/*! modules/OpenPgpWebclient/js/utils/Errors.js */ "RIpb"),
  Enums = __webpack_require__(/*! modules/OpenPgpWebclient/js/Enums.js */ "vfpp"),
  OpenPgp = __webpack_require__(/*! modules/OpenPgpWebclient/js/OpenPgp.js */ "E7cO");

/**
 * @constructor
 */
function CGenerateKeyPopup() {
  CAbstractPopup.call(this);
  this.emails = ko.observableArray([]);
  this.selectedEmail = ko.observable('');
  this.password = ko.observable('');
  this.keyLengthOptions = [2048, 4096];
  this.selectedKeyLength = ko.observable(2048);
  this.process = ko.observable(false);
  this.keysExistText = ko.observable('');
}
_.extendOwn(CGenerateKeyPopup.prototype, CAbstractPopup.prototype);
CGenerateKeyPopup.prototype.PopupTemplate = 'OpenPgpWebclient_GenerateKeyPopup';
CGenerateKeyPopup.prototype.onOpen = function () {
  var aDefaultEmails = App.getUserPublicId ? [App.getUserPublicId()] : [],
    aEmails = ModulesManager.run('MailWebclient', 'getAllAccountsFullEmails') || aDefaultEmails,
    aKeys = OpenPgp.getKeys(),
    aKeysEmails = _.map(aKeys, function (oKey) {
      var oEmailParts = AddressUtils.getEmailParts(oKey.user);
      return oEmailParts.email;
    }),
    aEmailsToUse = [];
  _.each(aEmails, function (sEmail) {
    var oEmailParts = AddressUtils.getEmailParts(sEmail);
    if (_.indexOf(aKeysEmails, oEmailParts.email) === -1) {
      aEmailsToUse.push(sEmail);
    }
  });
  if (aEmailsToUse.length === 0) {
    this.keysExistText(TextUtils.i18n('OPENPGPWEBCLIENT/INFO_KEYS_EXIST_PLURAL', {}, null, aEmails.length));
  }
  this.emails(aEmailsToUse);
  this.selectedEmail('');
  this.password('');
  this.selectedKeyLength(2048);
  this.process(false);
};
CGenerateKeyPopup.prototype.generate = function () {
  if (this.emails().length === 0) {
    return;
  }
  var fKeysGenerated = _.bind(function () {
      Screens.showReport(TextUtils.i18n('OPENPGPWEBCLIENT/REPORT_KEY_SUCCESSFULLY_GENERATED'));
      this.process(false);
      this.closePopup();
    }, this),
    fKeysGenerateError = _.bind(function () {
      ErrorsUtils.showPgpErrorByCode({}, Enums.PgpAction.Generate);
      this.process(false);
      this.closePopup();
    }, this);
  this.process(true);
  _.delay(_.bind(function () {
    OpenPgp.generateKey(this.selectedEmail(), $.trim(this.password()), this.selectedKeyLength(), fKeysGenerated, fKeysGenerateError);
  }, this));
};
module.exports = new CGenerateKeyPopup();

/***/ }),

/***/ "5MYD":
/*!**********************************************************************!*\
  !*** ./modules/OpenPgpWebclient/js/views/OpenPgpSettingsFormView.js ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



function _regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return _regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i["return"]) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function () { return this; }), _regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function _regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } _regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { _regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, _regeneratorDefine2(e, r, n, t); }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
  ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
  Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "PMEU"),
  Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh"),
  CAbstractSettingsFormView = ModulesManager.run('SettingsWebclient', 'getAbstractSettingsFormViewClass'),
  ErrorsUtils = __webpack_require__(/*! modules/OpenPgpWebclient/js/utils/Errors.js */ "RIpb"),
  GenerateKeyPopup = __webpack_require__(/*! modules/OpenPgpWebclient/js/popups/GenerateKeyPopup.js */ "22M0"),
  ImportKeyPopup = __webpack_require__(/*! modules/OpenPgpWebclient/js/popups/ImportKeyPopup.js */ "RqIR"),
  OpenPgp = __webpack_require__(/*! modules/OpenPgpWebclient/js/OpenPgp.js */ "E7cO"),
  Settings = __webpack_require__(/*! modules/OpenPgpWebclient/js/Settings.js */ "a9Z8"),
  ShowPublicKeysArmorPopup = __webpack_require__(/*! modules/OpenPgpWebclient/js/popups/ShowPublicKeysArmorPopup.js */ "Eq1/"),
  VerifyPasswordPopup = __webpack_require__(/*! modules/OpenPgpWebclient/js/popups/VerifyPasswordPopup.js */ "7EIX"),
  isTeamContactsAvailable = ModulesManager.isModuleAvailable('TeamContacts');

/**
 * @constructor
 */
function COpenPgpSettingsFormView() {
  CAbstractSettingsFormView.call(this, Settings.ServerModuleName);
  this.bTeamContactsAvailable = isTeamContactsAvailable;
  this.enableOpenPgpInMail = ko.observable(Settings.enableOpenPgpInMail());
  this.rememberPassphrase = Settings.rememberPassphrase;
  this.isMailAvailable = ModulesManager.isModuleAvailable('Mail');
  this.keys = ko.observableArray(OpenPgp.getKeys());
  OpenPgp.getKeysObservable().subscribe(function () {
    this.keys(OpenPgp.getKeys());
  }, this);
  this.noOwnKeyInTeamContacts = ko.computed(function () {
    return OpenPgp.ownKeyFromTeamContacts() === false;
  });
  this.publicKeysFromThisDevice = ko.computed(function () {
    return this.keys().filter(function (key) {
      return !key.isFromContacts && key.isPublic();
    }).map(function (key) {
      var isOwn = isTeamContactsAvailable && key.getEmail() === App.getUserPublicId(),
        ownKeyFromTeamContacts = OpenPgp.ownKeyFromTeamContacts(),
        isSameKeyFromTeamContacts = isOwn && ownKeyFromTeamContacts && key.getId() === ownKeyFromTeamContacts.getId();
      return {
        key: key,
        user: key.getUser(),
        isOwn: isOwn,
        hasOwnKeyFromTeamContacts: !!ownKeyFromTeamContacts,
        isSameKeyFromTeamContacts: isSameKeyFromTeamContacts
      };
    });
  }, this);
  this.privateKeysFromThisDevice = ko.computed(function () {
    return this.keys().filter(function (key) {
      return !key.isFromContacts && key.isPrivate();
    }).map(function (key) {
      return {
        key: key,
        user: key.getUser()
      };
    });
  }, this);
  this.keysFromPersonalContacts = ko.computed(function () {
    return this.keys().filter(function (key) {
      return key.isFromContacts;
    }).map(function (key) {
      return {
        key: key,
        user: key.getUser()
      };
    });
  }, this);
  this.oPgpKeyControlsView = ModulesManager.run('OpenPgpWebclient', 'getPgpKeyControlsView');
}
_.extendOwn(COpenPgpSettingsFormView.prototype, CAbstractSettingsFormView.prototype);
COpenPgpSettingsFormView.prototype.ViewTemplate = 'OpenPgpWebclient_OpenPgpSettingsFormView';
COpenPgpSettingsFormView.prototype.saveOwnKeyToTeamContact = /*#__PURE__*/function () {
  var _ref = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(key) {
    var armor, res;
    return _regenerator().w(function (_context) {
      while (1) switch (_context.n) {
        case 0:
          armor = key.getArmor();
          _context.n = 1;
          return OpenPgp.addKeyToContact(armor, '', true);
        case 1:
          res = _context.v;
          if (res && res.result) {
            Screens.showReport(TextUtils.i18n('OPENPGPWEBCLIENT/REPORT_KEY_SUCCESSFULLY_IMPORTED_PLURAL', {}, null, 1));
          } else {
            ErrorsUtils.showPgpErrorByCode(res, Enums.PgpAction.Import, TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_IMPORT_KEY'));
          }
        case 2:
          return _context.a(2);
      }
    }, _callee);
  }));
  return function (_x) {
    return _ref.apply(this, arguments);
  };
}();
COpenPgpSettingsFormView.prototype.exportAllPublicKeys = function () {
  var armors = _.map(_.union(this.publicKeysFromThisDevice(), this.keysFromPersonalContacts()), function (keyData) {
    return keyData.key.getArmor();
  });
  if (armors.length > 0) {
    Popups.showPopup(ShowPublicKeysArmorPopup, [armors.join('\n')]);
  }
};
COpenPgpSettingsFormView.prototype.importKey = function () {
  Popups.showPopup(ImportKeyPopup, [{}]);
};
COpenPgpSettingsFormView.prototype.generateNewKey = function () {
  Popups.showPopup(GenerateKeyPopup);
};
COpenPgpSettingsFormView.prototype.removeKeyFromContacts = function (key) {
  this.oPgpKeyControlsView.removeKeyFromContacts(key);
};

/**
 * @param {Object} key
 */
COpenPgpSettingsFormView.prototype.removeKeyFromThisDevice = function (key) {
  this.oPgpKeyControlsView.removeKeyFromThisDevice(key);
};

/**
 * @param {Object} key
 */
COpenPgpSettingsFormView.prototype.showArmor = function (key) {
  var _this = this;
  if (key.isPublic()) {
    this.oPgpKeyControlsView.showArmor(key);
  } else {
    Popups.showPopup(VerifyPasswordPopup, [key, function () {
      _this.oPgpKeyControlsView.showArmor(key);
    }]);
  }
};
COpenPgpSettingsFormView.prototype.getCurrentValues = function () {
  return [this.enableOpenPgpInMail(), this.rememberPassphrase()];
};
COpenPgpSettingsFormView.prototype.revertGlobalValues = function () {
  this.enableOpenPgpInMail(Settings.enableOpenPgpInMail());
  this.rememberPassphrase(Settings.rememberPassphrase());
};
COpenPgpSettingsFormView.prototype.getParametersForSave = function () {
  return {
    'EnableModule': this.enableOpenPgpInMail(),
    'RememberPassphrase': this.rememberPassphrase()
  };
};
COpenPgpSettingsFormView.prototype.applySavedValues = function (oParameters) {
  Settings.update(oParameters.EnableModule);
};
module.exports = new COpenPgpSettingsFormView();

/***/ }),

/***/ "7EIX":
/*!*******************************************************************!*\
  !*** ./modules/OpenPgpWebclient/js/popups/VerifyPasswordPopup.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



function _regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return _regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i["return"]) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function () { return this; }), _regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function _regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } _regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { _regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, _regeneratorDefine2(e, r, n, t); }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av"),
  ErrorsUtils = __webpack_require__(/*! modules/OpenPgpWebclient/js/utils/Errors.js */ "RIpb"),
  OpenPgp = __webpack_require__(/*! modules/OpenPgpWebclient/js/OpenPgp.js */ "E7cO");

/**
 * @constructor
 */
function CVerifyPasswordPopup() {
  CAbstractPopup.call(this);
  this.password = ko.observable('');
  this.oKey = null;
  this.fOkCallback = null;
}
_.extendOwn(CVerifyPasswordPopup.prototype, CAbstractPopup.prototype);
CVerifyPasswordPopup.prototype.PopupTemplate = 'OpenPgpWebclient_VerifyPasswordPopup';

/**
 * @param {object} oKey
 * @param {Function} fOkCallback
 */
CVerifyPasswordPopup.prototype.onOpen = function (oKey, fOkCallback) {
  this.password('');
  this.oKey = oKey;
  this.fOkCallback = fOkCallback;
};
CVerifyPasswordPopup.prototype.confirmPasswordAndView = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
  var oResult;
  return _regenerator().w(function (_context) {
    while (1) switch (_context.n) {
      case 0:
        _context.n = 1;
        return OpenPgp.verifyKeyPassword(this.oKey, this.password());
      case 1:
        oResult = _context.v;
        if (oResult.errors) {
          ErrorsUtils.showPgpErrorByCode(oResult);
        } else {
          if (_.isFunction(this.fOkCallback)) {
            this.fOkCallback();
            this.closePopup();
          }
        }
      case 2:
        return _context.a(2);
    }
  }, _callee, this);
}));
module.exports = new CVerifyPasswordPopup();

/***/ }),

/***/ "Eq1/":
/*!************************************************************************!*\
  !*** ./modules/OpenPgpWebclient/js/popups/ShowPublicKeysArmorPopup.js ***!
  \************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Ajax = __webpack_require__(/*! modules/CoreWebclient/js/Ajax.js */ "8QQh"),
  ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
  Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh"),
  ComposeMessageWithAttachments = ModulesManager.run('MailWebclient', 'getComposeMessageWithAttachments'),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av");

/**
 * @constructor
 */
function CShowKeyArmorPopup() {
  CAbstractPopup.call(this);
  this.bAllowSendEmails = _.isFunction(ComposeMessageWithAttachments);
  this.armors = ko.observable('');
  this.htmlArmor = ko.computed(function () {
    return TextUtils.encodeHtml(this.armors().replace(/\r/g, ''));
  }, this);
  this.popupHeading = ko.computed(function () {
    return TextUtils.i18n('OPENPGPWEBCLIENT/HEADING_VIEW_ALL_PUBLIC_KEYS');
  }, this);
  this.downloadLinkHref = ko.computed(function () {
    var sHref = '#',
      oBlob = null;
    if (Blob && window.URL && _.isFunction(window.URL.createObjectURL)) {
      oBlob = new Blob([this.armors()], {
        type: 'text/plain'
      });
      sHref = window.URL.createObjectURL(oBlob);
    }
    return sHref;
  }, this);
  this.downloadLinkFilename = ko.computed(function () {
    return TextUtils.i18n('OPENPGPWEBCLIENT/TEXT_ALL_PUBLIC_KEYS_FILENAME') + '.asc';
  }, this);
  this.domKey = ko.observable(null);
}
_.extendOwn(CShowKeyArmorPopup.prototype, CAbstractPopup.prototype);
CShowKeyArmorPopup.prototype.PopupTemplate = 'OpenPgpWebclient_ShowKeyArmorPopup';

/**
 * @param {string} sArmors
 */
CShowKeyArmorPopup.prototype.onOpen = function (sArmors) {
  this.armors(sArmors);
};
CShowKeyArmorPopup.prototype.send = function () {
  if (this.bAllowSendEmails && this.armors() !== '' && this.downloadLinkFilename() !== '') {
    Ajax.send('OpenPgpWebclient', 'SaveKeyAsTempFile', {
      'Content': this.armors(),
      'FileName': this.downloadLinkFilename()
    }, function (oResponse) {
      if (oResponse.Result) {
        ComposeMessageWithAttachments([oResponse.Result]);
        this.closePopup();
      }
    }, this);
  }
};
CShowKeyArmorPopup.prototype.select = function () {
  var oDomKey = this.domKey() && this.domKey().length === 1 ? this.domKey()[0] : null,
    oSel = null,
    oRange = null;
  if (oDomKey && window.getSelection && document.createRange) {
    oRange = document.createRange();
    oRange.setStart(oDomKey, 0);
    oRange.setEnd(oDomKey, 1);
    oSel = window.getSelection();
    oSel.removeAllRanges();
    oSel.addRange(oRange);
    if (document.queryCommandSupported('copy')) {
      document.execCommand('copy');
      Screens.showReport(TextUtils.i18n('OPENPGPWEBCLIENT/REPORT_KEY_IN_CLIPBOARD'));
    }
  }
};
module.exports = new CShowKeyArmorPopup();

/***/ }),

/***/ "rvaB":
/*!*****************************************************************!*\
  !*** ./modules/OpenPgpWebclient/js/popups/ShowKeyArmorPopup.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Ajax = __webpack_require__(/*! modules/CoreWebclient/js/Ajax.js */ "8QQh"),
  ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
  Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh"),
  Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "PMEU"),
  ConfirmPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/ConfirmPopup.js */ "MYiO"),
  ComposeMessageWithAttachments = ModulesManager.run('MailWebclient', 'getComposeMessageWithAttachments'),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av");

/**
 * @constructor
 */
function CShowKeyArmorPopup() {
  CAbstractPopup.call(this);
  this.bAllowSendEmails = _.isFunction(ComposeMessageWithAttachments);
  this.armor = ko.observable('');
  this.htmlArmor = ko.computed(function () {
    return TextUtils.encodeHtml(this.armor().replace(/\r/g, ''));
  }, this);
  this.user = ko.observable('');
  this["private"] = ko.observable(false);
  this.popupHeading = ko.computed(function () {
    return this["private"]() ? TextUtils.i18n('OPENPGPWEBCLIENT/HEADING_VIEW_PRIVATE_KEY', {
      'USER': this.user()
    }) : TextUtils.i18n('OPENPGPWEBCLIENT/HEADING_VIEW_PUBLIC_KEY', {
      'USER': this.user()
    });
  }, this);
  this.downloadLinkHref = ko.computed(function () {
    var sHref = '#',
      oBlob = null;
    if (Blob && window.URL && _.isFunction(window.URL.createObjectURL)) {
      oBlob = new Blob([this.armor()], {
        type: 'text/plain'
      });
      sHref = window.URL.createObjectURL(oBlob);
    }
    return sHref;
  }, this);
  this.downloadLinkFilename = ko.computed(function () {
    var sConvertedUser = this.user().replace(/</g, '').replace(/>/g, ''),
      sLangKey = this["private"]() ? 'OPENPGPWEBCLIENT/TEXT_PRIVATE_KEY_FILENAME' : 'OPENPGPWEBCLIENT/TEXT_PUBLIC_KEY_FILENAME';
    return TextUtils.i18n(sLangKey, {
      'USER': sConvertedUser
    }) + '.asc';
  }, this);
  this.domKey = ko.observable(null);
}
_.extendOwn(CShowKeyArmorPopup.prototype, CAbstractPopup.prototype);
CShowKeyArmorPopup.prototype.PopupTemplate = 'OpenPgpWebclient_ShowKeyArmorPopup';

/**
 * @param {Object} oKey
 */
CShowKeyArmorPopup.prototype.onOpen = function (oKey) {
  this.armor(oKey.getArmor());
  this.user(oKey.getUser());
  this["private"](oKey.isPrivate());
};
CShowKeyArmorPopup.prototype.send = function () {
  var _this = this;
  var fSend = function fSend() {
    if (_this.bAllowSendEmails && _this.armor() !== '' && _this.downloadLinkFilename() !== '') {
      Ajax.send('OpenPgpWebclient', 'SaveKeyAsTempFile', {
        'Content': _this.armor(),
        'FileName': _this.downloadLinkFilename()
      }, function (oResponse) {
        if (oResponse.Result) {
          ComposeMessageWithAttachments([oResponse.Result]);
          this.closePopup();
        }
      }, _this);
    }
  };
  if (this["private"]()) {
    var sConfirm = TextUtils.i18n('OPENPGPWEBCLIENT/CONFIRM_SEND_PRIVATE_KEY');
    Popups.showPopup(ConfirmPopup, [sConfirm, function (bSend) {
      if (bSend) {
        fSend();
      }
    }]);
  } else {
    fSend();
  }
};
CShowKeyArmorPopup.prototype.select = function () {
  var oDomKey = this.domKey() && this.domKey().length === 1 ? this.domKey()[0] : null,
    oSel = null,
    oRange = null;
  if (oDomKey && window.getSelection && document.createRange) {
    oRange = document.createRange();
    oRange.setStart(oDomKey, 0);
    oRange.setEnd(oDomKey, 1);
    oSel = window.getSelection();
    oSel.removeAllRanges();
    oSel.addRange(oRange);
    if (document.queryCommandSupported('copy')) {
      document.execCommand('copy');
      Screens.showReport(TextUtils.i18n('OPENPGPWEBCLIENT/REPORT_KEY_IN_CLIPBOARD'));
    }
  }
};
module.exports = new CShowKeyArmorPopup();

/***/ })

}]);