"use strict";
(self["webpackChunkaurora_webmail_pro"] = self["webpackChunkaurora_webmail_pro"] || []).push([[12],{

/***/ "52ri":
/*!*************************************************************!*\
  !*** ./modules/FilesTableviewWebclientPlugin/js/manager.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



module.exports = function (oAppData) {
  var $ = __webpack_require__(/*! jquery */ "M4cL"),
    ko = __webpack_require__(/*! knockout */ "p09A"),
    TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
    App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
    Settings = __webpack_require__(/*! modules/FilesTableviewWebclientPlugin/js/Settings.js */ "Qgpy"),
    bShow = false,
    TemplateName = 'FilesTableviewWebclientPlugin_ItemsView',
    ToggleFilesButtonView = null;
  Settings.init(oAppData);
  function getButtonView() {
    if (!ToggleFilesButtonView) {
      ToggleFilesButtonView = __webpack_require__(/*! modules/FilesTableviewWebclientPlugin/js/views/ToggleFilesButtonView.js */ "SKgy");
    }
    return ToggleFilesButtonView;
  }
  if (App.isUserNormalOrTenant()) {
    return {
      start: function start(ModulesManager) {
        ModulesManager.run('SettingsWebclient', 'registerSettingsTabSection', [function () {
          return __webpack_require__(/*! modules/FilesTableviewWebclientPlugin/js/views/FilesTableviewSettingsFormView.js */ "QT7V");
        }, Settings.HashModuleName, TextUtils.i18n('FILESTABLEVIEWWEBCLIENTPLUGIN/LABEL_SETTINGS_TAB')]);
        App.subscribeEvent('FilesWebclient::ConstructView::after', function (oParams) {
          if ('CFilesView' === oParams.Name) {
            var originalTemplateName = oParams.View.itemsViewTemplate();
            if (Settings.enableModule()) {
              oParams.View.itemsViewTemplate(TemplateName);
            }
            Settings.enableModule.subscribe(function (newValue) {
              oParams.View.itemsViewTemplate(newValue ? TemplateName : originalTemplateName);
            });
          }
        });
        App.subscribeEvent('FilesWebclient::ShowView::after', function (oParams) {
          var previewFileData = {
              displayName: ko.observable(''),
              enablePreviewPane: Settings.enablePreviewPane,
              type: ko.observable(''),
              size: ko.observable(''),
              // created: ko.observable(''),
              modified: ko.observable(''),
              location: ko.observable(''),
              extension: ko.observable(''),
              hasSelectedFile: ko.observable(false),
              showPreview: ko.observable(false)
            },
            $RightPannel = $("<!-- ko template: {name: 'FilesTableviewWebclientPlugin_PaneView'} --><!-- /ko -->"),
            aImgMimeTypes = ['image/jpeg', 'image/png', 'image/gif'];
          if (!bShow) {
            bShow = true;
            $("#files_center_panel").after($RightPannel);
            ko.applyBindings(previewFileData, $RightPannel.get(0));
            oParams.View.firstSelectedFile.subscribe(function (selectedFile) {
              var fileIsSelected = !!selectedFile;
              previewFileData.displayName('');
              previewFileData.type('');
              previewFileData.size('');
              // previewFileData.created('');
              previewFileData.modified('');
              previewFileData.location('');
              previewFileData.hasSelectedFile(fileIsSelected);
              previewFileData.extension('');
              previewFileData.showPreview(false);
              $("#files_view_pane").html("");
              if (selectedFile !== undefined && Settings.enablePreviewPane()) {
                previewFileData.displayName(selectedFile.displayName());
                previewFileData.type(selectedFile.type ? selectedFile.type() : '');
                previewFileData.size(selectedFile.friendlySize ? selectedFile.friendlySize() : '');
                // previewFileData.created(selectedFile.sHeaderText ? selectedFile.sHeaderText : '');
                previewFileData.modified(selectedFile.sLastModified ? selectedFile.sLastModified : '');
                previewFileData.location(selectedFile.path && selectedFile.path() ? selectedFile.path() : '/');
                previewFileData.extension(selectedFile.extension ? selectedFile.extension() : '');
                if (selectedFile.getActionUrl('view') !== '') {
                  previewFileData.showPreview(true);
                  // paranoid encryption hero
                  if (typeof selectedFile.oExtendedProps !== 'undefined' && typeof selectedFile.oExtendedProps.InitializationVector !== 'undefined') {
                    $("#files_view_pane").html("<div class='item key'><span class='icon'/></div>");
                  } else if (-1 !== $.inArray(selectedFile.mimeType(), aImgMimeTypes)) {
                    $("#files_view_pane").html("<img src='" + selectedFile.getActionUrl('view') + "'>");
                  } else {
                    $("#files_view_pane").html("<iframe class='view_iframe' src='" + selectedFile.getActionUrl('view') + "'></iframe>");
                  }
                }
              }
            });
          }
        });
        ModulesManager.run('FilesWebclient', 'registerToolbarButtons', [getButtonView()]);
      }
    };
  }
  return null;
};

/***/ }),

/***/ "QT7V":
/*!******************************************************************************************!*\
  !*** ./modules/FilesTableviewWebclientPlugin/js/views/FilesTableviewSettingsFormView.js ***!
  \******************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
  CAbstractSettingsFormView = ModulesManager.run('SettingsWebclient', 'getAbstractSettingsFormViewClass'),
  Settings = __webpack_require__(/*! modules/FilesTableviewWebclientPlugin/js/Settings.js */ "Qgpy");

/**
 * Inherits from CAbstractSettingsFormView that has methods for showing and hiding settings tab,
 * updating settings values on the server, checking if there was changins on the settings page.
 * 
 * @constructor
 */
function CFilesTableviewSettingsFormView() {
  CAbstractSettingsFormView.call(this, Settings.ServerModuleName);
  this.enableModule = ko.observable(Settings.enableModule());
  this.enablePreviewPane = ko.observable(Settings.enablePreviewPane());
}
_.extendOwn(CFilesTableviewSettingsFormView.prototype, CAbstractSettingsFormView.prototype);

/**
 * Name of template that will be bound to this JS-object.
 * 'FilesTableviewSettingsFormView' - name of template file in 'templates' folder.
 */
CFilesTableviewSettingsFormView.prototype.ViewTemplate = 'FilesTableviewWebclientPlugin_FilesTableviewSettingsFormView';

/**
 * Returns array with all settings values wich is used for indicating if there were changes on the page.
 * 
 * @returns {Array} Array with all settings values;
 */
CFilesTableviewSettingsFormView.prototype.getCurrentValues = function () {
  return [this.enableModule(), this.enablePreviewPane()];
};

/**
 * Reverts all settings values to global ones.
 */
CFilesTableviewSettingsFormView.prototype.revertGlobalValues = function () {
  this.enableModule(Settings.enableModule());
  this.enablePreviewPane(Settings.enablePreviewPane());
};

/**
 * Returns Object with parameters for passing to the server while settings updating.
 * 
 * @returns Object
 */
CFilesTableviewSettingsFormView.prototype.getParametersForSave = function () {
  return {
    'EnableModule': this.enableModule(),
    'EnablePreviewPane': this.enablePreviewPane()
  };
};

/**
 * Applies new settings values to global settings object.
 * 
 * @param {Object} oParameters Parameters with new values which were passed to the server.
 */
CFilesTableviewSettingsFormView.prototype.applySavedValues = function (oParameters) {
  Settings.update(oParameters.EnableModule, oParameters.EnablePreviewPane);
};
module.exports = new CFilesTableviewSettingsFormView();

/***/ }),

/***/ "Qgpy":
/*!**************************************************************!*\
  !*** ./modules/FilesTableviewWebclientPlugin/js/Settings.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var ko = __webpack_require__(/*! knockout */ "p09A"),
  _ = __webpack_require__(/*! underscore */ "C3HO"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9");
module.exports = {
  ServerModuleName: 'FilesTableviewWebclientPlugin',
  HashModuleName: 'files',
  /**
   * Setting indicates if module is enabled by user or not.
   * The Core subscribes to this setting changes and if it is **true** displays module tab in header and its screens.
   * Otherwise the Core doesn't display module tab in header and its screens.
   */
  enableModule: ko.observable(false),
  enablePreviewPane: ko.observable(false),
  /**
   * Initializes settings from AppData object sections.
   * 
   * @param {Object} oAppData Object contained modules settings.
   */
  init: function init(oAppData) {
    var oAppDataSection = oAppData['FilesTableviewWebclientPlugin'];
    if (!_.isEmpty(oAppDataSection)) {
      this.enableModule(Types.pBool(oAppDataSection.EnableModule, this.enableModule()));
      this.enablePreviewPane(Types.pBool(oAppDataSection.EnablePreviewPane, this.enablePreviewPane()));
    }
  },
  /**
   * Updates module settings after editing.
   * 
   * @param {boolean} bEnableModule New value of setting 'EnableModule'
   * @param {boolean} bEnablePreviewPane New value of setting 'EnablePreviewPane'
   */
  update: function update(bEnableModule) {
    var bEnablePreviewPane = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.enablePreviewPane();
    this.enableModule(bEnableModule);
    this.enablePreviewPane(bEnablePreviewPane);
  }
};

/***/ }),

/***/ "SKgy":
/*!*********************************************************************************!*\
  !*** ./modules/FilesTableviewWebclientPlugin/js/views/ToggleFilesButtonView.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var Settings = __webpack_require__(/*! modules/FilesTableviewWebclientPlugin/js/Settings.js */ "Qgpy"),
  Ajax = __webpack_require__(/*! modules/CoreWebclient/js/Ajax.js */ "8QQh"),
  Utils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Common.js */ "uQaC"),
  FilesTableviewSettingsFormView = __webpack_require__(/*! modules/FilesTableviewWebclientPlugin/js/views/FilesTableviewSettingsFormView.js */ "QT7V");

/**
 * @constructor
 */
function CToggleFilesButtonView() {
  this.tableView = Settings.enableModule;
}
function onChangeFilesViewType() {
  var isTable = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  if (Settings.enableModule() !== isTable) {
    Settings.enableModule(isTable);
    FilesTableviewSettingsFormView.enableModule(isTable);
    Ajax.send('FilesTableviewWebclientPlugin', 'UpdateSettings', {
      'EnableModule': isTable
    });
  }
}
CToggleFilesButtonView.prototype.ViewTemplate = 'FilesTableviewWebclientPlugin_ToggleFilesButtonView';
CToggleFilesButtonView.prototype.useFilesViewData = function () {
  this.useGridFilesViewCommand = Utils.createCommand(this, function () {
    return onChangeFilesViewType();
  });
  this.useListFilesViewCommand = Utils.createCommand(this, function () {
    return onChangeFilesViewType(true);
  });
};
module.exports = new CToggleFilesButtonView();

/***/ })

}]);