"use strict";
(self["webpackChunkaurora_webmail_pro"] = self["webpackChunkaurora_webmail_pro"] || []).push([[22],{

/***/ "8hy2":
/*!********************************************************************************!*\
  !*** ./modules/MailSaveAttachmentsToFilesPlugin/js/popups/SelectFilesPopup.js ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "M4cL");


var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Utils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Common.js */ "uQaC"),
  Ajax = __webpack_require__(/*! modules/CoreWebclient/js/Ajax.js */ "8QQh"),
  Api = __webpack_require__(/*! modules/CoreWebclient/js/Api.js */ "Z9uT"),
  App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av"),
  CJua = __webpack_require__(/*! modules/CoreWebclient/js/CJua.js */ "hr1f"),
  ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
  Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "PMEU"),
  Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh"),
  UserSettings = __webpack_require__(/*! modules/CoreWebclient/js/Settings.js */ "KIwC"),
  CFilesView = __webpack_require__(/*! modules/FilesWebclient/js/views/CFilesView.js */ "v0iR"),
  isCoreParanoidModuleEnabled = ModulesManager.run('CoreParanoidEncryptionWebclientPlugin', 'isEnabled');

/**
 * @constructor
 */
function CSelectFilesPopup() {
  CAbstractPopup.call(this);
  this.filesView = new CFilesView(true, false);
  this.filesView.onSelectClickPopupBound = function () {};
  this.filesView.onCreateFolderResponse = function (response, request) {
    if (!response.Result) {
      Api.showErrorByCode(response);
      this.routeFiles(this.storageType(), this.currentPath(), this.searchPattern(), true);
    } else {
      var path = "".concat(request.Parameters.Path, "/").concat(request.Parameters.FolderName),
        storage = request.Parameters.Type;
      this.routeFiles(storage, path, '', true);
    }
  }.bind(this.filesView);
  this.isSaving = ko.observable(false);
  this.isSaving.subscribe(function () {
    this.filesView.disableRoute = this.isSaving();
  }, this);
  this.allowCreateFolder = ko.computed(function () {
    return !this.isSaving();
  }, this);
  this.createFolderCommand = Utils.createCommand(this, this.createFolder, this.allowCreateFolder);
  this.allowSelectFolder = ko.computed(function () {
    return !this.isSaving() && (this.filesView.storageType() !== 'shared' || this.filesView.currentPath() !== '');
  }, this);
  this.selectFolderCommand = Utils.createCommand(this, this.selectFolder, this.allowSelectFolder);
}
_.extendOwn(CSelectFilesPopup.prototype, CAbstractPopup.prototype);
CSelectFilesPopup.prototype.PopupTemplate = 'MailSaveAttachmentsToFilesPlugin_SelectFilesPopup';

/**
 * @param {array} attachments
 * @param {int} accountId
 */
CSelectFilesPopup.prototype.onOpen = function (attachments, accountId) {
  this.initUploader();
  this.attachmentsData = attachments.map(function (attach) {
    return {
      attach: attach,
      FileName: attach.fileName(),
      Size: attach.size(),
      Hash: attach.hash(),
      Type: attach.mimeType()
    };
  });
  this.accountId = accountId;
  this.filesView.onShow();
  this.filesView.routeFiles('personal', '');
};
CSelectFilesPopup.prototype.onBind = function () {
  this.filesView.onBind(this.$popupDom);
};
CSelectFilesPopup.prototype.hideLoading = function () {
  this.isSaving(false);
  Screens.hideLoading();
};
CSelectFilesPopup.prototype.onClose = function () {
  this.hideLoading();
};
CSelectFilesPopup.prototype.selectFolder = function () {
  var _this = this;
  var filesData = this.attachmentsData.filter(function (fileData) {
    return _this.filesView.isFileCanBeUploaded(fileData);
  });
  if (filesData.length > 0) {
    var storageType = this.filesView.storageType(),
      currentPath = this.filesView.currentPath(),
      saveToFolderArgs = [storageType, currentPath, this.accountId, filesData],
      encryptAndSaveHandler = function encryptAndSaveHandler() {
        _this.encryptAndSaveToFolder(filesData);
      },
      saveHandler = function saveHandler() {
        _this.saveToFolder.apply(_this, saveToFolderArgs);
      },
      cancelHandler = function cancelHandler() {
        _this.closePopup();
      };
    if (isCoreParanoidModuleEnabled) {
      // get ConfirmEncryptionPopup every time in case the EnableInPersonalStorage setting has changed
      var ConfirmEncryptionPopup = ModulesManager.run('CoreParanoidEncryptionWebclientPlugin', 'getConfirmEncryptionPopup');
      if (this.filesView.storageType() === 'encrypted') {
        encryptAndSaveHandler();
      } else if (this.filesView.storageType() === 'personal' && ConfirmEncryptionPopup) {
        Popups.showPopup(ConfirmEncryptionPopup, [encryptAndSaveHandler, saveHandler, cancelHandler, filesData.length, filesData.map(function (fileData) {
          return fileData.FileName;
        })]);
      } else {
        saveHandler();
      }
    } else {
      saveHandler();
    }
  }
};
CSelectFilesPopup.prototype.saveToFolder = function (storage, path, accountId, filesData) {
  var _this2 = this;
  filesData.forEach(function (fileData) {
    _this2.filesView.onFileUploadSelect(fileData.Hash, fileData);
    _this2.filesView.onFileUploadStart(fileData.Hash);
    _this2.filesView.onFileUploadProgress(fileData.Hash, fileData.Size * 0.2, fileData.Size);
  });
  var hashes = filesData.map(function (fileData) {
      return fileData.Hash;
    }),
    parameters = {
      'AccountID': accountId,
      'Attachments': hashes,
      'Storage': storage,
      'Path': path
    },
    responseHandler = function responseHandler(response) {
      _this2.hideLoading();
      if (response.Result) {
        _this2.attachmentsData.forEach(function (fileData) {
          _this2.filesView.onFileUploadComplete(fileData.Hash, true, {
            Result: true
          });
        });
        _this2.onFileUploadComplete();
      } else {
        Api.showErrorByCode(response);
      }
    };
  Screens.showLoading(TextUtils.i18n('COREWEBCLIENT/INFO_LOADING'));
  this.isSaving(true);
  Ajax.send('MailSaveAttachmentsToFilesPlugin', 'Save', parameters, responseHandler);
};
CSelectFilesPopup.prototype.onFileUploadComplete = function () {
  var _this3 = this;
  if (this.filesView.uploadingFiles().length > 0) {
    return;
  }
  var headerItemView = ModulesManager.run('FilesWebclient', 'getHeaderItem');
  if (headerItemView && headerItemView.item) {
    headerItemView.item.recivedAnim(true);
  }
  var filesCount = this.attachmentsData.length,
    reportLang = 'MAILSAVEATTACHMENTSTOFILESPLUGIN/REPORT_FILES_SAVED_SUCCESSFULLY_PLURAL',
    reportText = TextUtils.i18n(reportLang, null, null, filesCount);
  Screens.showReport(reportText);
  setTimeout(function () {
    _this3.closePopup();
  }, 1000);
  this.hideLoading();
};
CSelectFilesPopup.prototype.encryptAndSaveToFolder = function (filesData) {
  var _this4 = this;
  filesData.forEach(function (fileData) {
    _this4.filesView.onFileUploadSelect(fileData.Hash, fileData);
    _this4.filesView.onFileUploadStart(fileData.Hash);
    _this4.filesView.onFileUploadProgress(fileData.Hash, fileData.Size * 0.1, fileData.Size);
  });
  Screens.showLoading(TextUtils.i18n('COREWEBCLIENT/INFO_LOADING'));
  this.isSaving(true);
  var attaches = filesData.map(function (fileData) {
    return fileData.attach;
  });
  attaches.forEach(function (attach) {
    var downloadUrl = attach.getActionUrl('download');
    jQuery.ajax({
      url: downloadUrl,
      cache: false,
      xhrFields: {
        responseType: 'blob'
      },
      success: function success(blobData) {
        _this4.encryptBlob(attach, blobData);
      },
      error: function error(_error) {
        this.hideLoading();
        this.filesView.onFileUploadComplete(attach.hash(), false, {
          Result: false
        });
      }
    });
  });
};
CSelectFilesPopup.prototype.encryptBlob = function (attach, blobData) {
  this.oJua.addFile(attach.hash(), {
    File: blobData,
    FileName: attach.fileName(),
    Folder: '',
    Size: blobData.size,
    Type: blobData.type,
    EncryptWithoutConfirm: true
  });
  var file = this.filesView.getUploadFileByUid(attach.hash());
  if (file) {
    this.filesView.onFileUploadProgress(attach.hash(), file.size() * 0.2, file.size());
  }
};
CSelectFilesPopup.prototype.initUploader = function () {
  var _this5 = this;
  if (!this.oJua) {
    this.oJua = new CJua({
      'action': '?/Api/',
      'name': 'jua-uploader',
      'queueSize': 2,
      'clickElement': null,
      'hiddenElementsPosition': UserSettings.IsRTL ? 'right' : 'left',
      'dragAndDropElement': null,
      'disableAjaxUpload': false,
      'disableFolderDragAndDrop': true,
      'disableDragAndDrop': true,
      'hidden': _.extendOwn({
        'Module': 'Files',
        'Method': 'UploadFile',
        'Parameters': function Parameters(file) {
          return JSON.stringify({
            'Type': _this5.filesView.storageType(),
            'SubPath': '',
            'Path': _this5.filesView.currentPath(),
            'Overwrite': false
          });
        }
      }, App.getCommonRequestParameters())
    });
    this.oJua.on('onProgress', function (fileUid, uploadedSize, fileSize) {
      var percent = uploadedSize / fileSize;
      if (percent < 0.2) {
        percent = 0.2;
      }
      _this5.filesView.onFileUploadProgress(fileUid, fileSize * percent, fileSize);
    }).on('onSelect', this.filesView.onFileUploadSelect.bind(this.filesView)).on('onStart', function (fileUid) {
      _this5.filesView.onFileUploadStart(fileUid);
      var file = _this5.filesView.getUploadFileByUid(fileUid);
      if (file) {
        _this5.filesView.onFileUploadProgress(fileUid, file.size() * 0.2, file.size());
      }
    }).on('onComplete', function (fileUid, isResponseReceived, result) {
      _this5.filesView.onFileUploadComplete(fileUid, isResponseReceived, result);
      _this5.onFileUploadComplete();
    }).on('onCancel', function (fileUid) {
      _this5.filesView.onCancelUpload(fileUid);
      if (_this5.filesView.uploadingFiles().length === 0) {
        _this5.hideLoading();
      }
    });
  }
};
CSelectFilesPopup.prototype.createFolder = function () {
  this.filesView.executeCreateFolder();
};
module.exports = new CSelectFilesPopup();

/***/ }),

/***/ "AgYu":
/*!****************************************************************!*\
  !*** ./modules/MailSaveAttachmentsToFilesPlugin/js/manager.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



module.exports = function (appData) {
  var TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
    App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
    ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l");
  if (!ModulesManager.isModuleEnabled('FilesWebclient')) {
    return null;
  }
  if (App.isUserNormalOrTenant()) {
    return {
      start: function start(ModulesManager) {
        App.subscribeEvent('MailWebclient::AddAllAttachmentsDownloadMethod', function (fAddAllAttachmentsDownloadMethod) {
          fAddAllAttachmentsDownloadMethod({
            'Text': TextUtils.i18n('MAILSAVEATTACHMENTSTOFILESPLUGIN/ACTION_SAVE_ATTACHMENTS_TO_FILES'),
            'Handler': function Handler(accountId, hashes, attachments) {
              var Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "PMEU"),
                SelectFilesPopup = __webpack_require__(/*! modules/MailSaveAttachmentsToFilesPlugin/js/popups/SelectFilesPopup.js */ "8hy2");
              Popups.showPopup(SelectFilesPopup, [attachments, accountId]);
            }
          });
        });
      }
    };
  }
  return null;
};

/***/ })

}]);