#!/usr/local/cpanel/3rdparty/bin/php -q
<?php
$input = get_passed_data(); 

list($result_result, $result_message) = remove_user($input);

function remove_user($input = array())
{
    include __DIR__.'/../system/autoload.php';
    \Aurora\System\Api::Init(true);

    if (!$input['data']['args']['domain'])
    {
        list($sLogin, $sDomainName) = explode('@', $input['data']['args']['email']);
        $input['data']['args']['domain'] = $sDomainName;
        $input['data']['args']['email'] = $sLogin;
    }
    if ($input && $input['data'] && $input['data']['args']
        && $input['data']['args']['domain'] && $input['data']['args']['email']
        && !empty($input['data']['args']['domain'])
        && !empty($input['data']['args']['email'])
    )
    {
        $email = $input['data']['args']['email'] . "@" . $input['data']['args']['domain'];
        $oUser = \Aurora\System\Api::GetModuleDecorator('Core')->GetUserByPublicId($email);
        if ($oUser instanceof \Aurora\Modules\Core\Classes\User)
        {

                if (\Aurora\Modules\Core\Module::Decorator()->DeleteUser($oUser->EntityId))
                {
                    \Aurora\System\Api::Log("User {$email} was successfully deleted", \Aurora\System\Enums\LogLevel::Full, 'cpanel-');
                }
                else
                {
                    \Aurora\System\Api::Log("User {$email} wasn't deleted", \Aurora\System\Enums\LogLevel::Full, 'cpanel-');
                }
        }
        else
        {
             \Aurora\System\Api::Log("User {$email} not found", \Aurora\System\Enums\LogLevel::Full, 'cpanel-');
        }
    }
}

// Process data from STDIN.
function get_passed_data()
{
 
    // Get input from STDIN.
    $raw_data;
    $stdin_fh = fopen('php://stdin', 'r');
    if ( is_resource($stdin_fh) )
    {
        stream_set_blocking($stdin_fh, 0);
        while ( ($line = fgets( $stdin_fh, 1024 )) !== false ) {
            $raw_data .= trim($line);
        }
        fclose($stdin_fh);
    }
 
    // Process and JSON-decode the raw output.
    if ($raw_data)
    {
        $input_data = json_decode($raw_data, true);
    }
    else
    {
        $input_data = array('context'=>array(),'data'=>array(), 'hook'=>array());
    }
 
    // Return the output.
    return $input_data;
}