

/*jshint node: true */

'use strict';

module.exports = function(grunt) {
	
	grunt.initConfig({
		pkg: grunt.file.readJSON('package.json'),
		cfg: {
			releasesSrcPath: ''
		},
		less: {
			options: {
				optimization: 2,
				compress: false,
				yuicompress: false
			},
			Default: {
				files: {
					"skins/Default/styles.css": "skins/Default/less/styles.less",
					"skins/Default/styles-mobile.css": "skins/Default/less/styles-mobile.less"
				}
			},
			MY_SKIN_NAME: {
				files: {
					"skins/MY_SKIN_NAME/styles.css": "skins/MY_SKIN_NAME/less/styles.less",
					"skins/MY_SKIN_NAME/styles-mobile.css": "skins/MY_SKIN_NAME/less/styles-mobile.less"
				}
			}
		},
		watch: {
			options: {
				nospawn: true
			},
			SkinsLess: {
				files: ['skins/**/less/**/*.less'],
				tasks: ['less']
			}
		}
	});

	// dependencies
	for (var key in grunt.file.readJSON('package.json').devDependencies) {
		if (key.indexOf('grunt-') === 0) {
			grunt.loadNpmTasks(key);
		}
	}

	grunt.registerTask('default', ['less']);
	grunt.registerTask('w', ['default', 'watch']);
	grunt.registerTask('watch-css-only', ['w']);
};
